<?php

App::uses('View', 'View');

class EvCustomView extends View {

	public function __construct(Controller $controller = null) {
		parent::__construct($controller);

		$this->Number->addFormat(
			'GBP',
			array(
				'wholeSymbol' => '£', 'wholePosition' => 'before', 'fractionSymbol' => 'p', 'fractionPosition' => 'after',
				'zero' => 0, 'places' => 2, 'thousands' => ',', 'decimals' => '.', 'negative' => '-', 'escape' => true,
				'fractionExponent' => 2
			)
		);
	}

	/**
	 * redefined to check and loop our collection of helpers for overriden files
	 *
	 * Interact with the HelperCollection to load all the helpers.
	 *
	 * @return void
	 */
	public function loadHelpers() {
		// Evoluted Amend. Loop and check for any plugins in helpers
		// Check these haven't been overwritten
		if (! empty($this->helpers)) {

			if (isset($this->helpers['DebugKit.Toolbar'])) {
				$debugKit = $this->helpers['DebugKit.Toolbar'];
				unset($this->helpers['DebugKit.Toolbar']);
			}

			$this->helpers = EvClassRegistry::checkOverridingItems('helpers', $this->helpers);

			if (isset($debugKit)) {
				$this->helpers['DebugKit.Toolbar'] = $debugKit;
			}
		}

		parent::loadHelpers();
	}

	/**
	 * Loads a helper. Delegates to the `HelperCollection::load()` to load the helper
	 *
	 * @param string $helperName Name of the helper to load.
	 * @param array $settings Settings for the helper
	 * @return Helper a constructed helper object.
	 * @see HelperCollection::load()
	 */
	public function loadHelper($helperName, $settings = array()) {
		// check for a plugin / overriding file
		$origHelper = $helperName;

		if (! empty($settings['className'])) {
			$helperName = $settings['className'];
		}

		$helperName = EvClassRegistry::findOverrideHelper($helperName);
		$settings['className'] = $helperName;

		// as we have set the className, we need to chop up the original
		// helper call if it was a plugin to set the alias correctly.
		$helperName = EvClassRegistry::getNewArrayKey($origHelper);

		return parent::loadHelper($helperName, $settings);
	}
}
