<?php

/**
 * Business rules for Pages
 */
class EvPage extends AppModel {

	public $useTable = "pages";

	public $displayField = 'title';

	public $actsAs = array(
		'Routable.Routable',
		'MetaData.Meta',
		'Navigation.Navigatable'
	);

	public $validate = array(
		'title' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'cannot be blank'
			)
		)
	);


/**
 * Model pre-save logic
 */
	public function beforeSave($options = array()) {

		// remove trailing empty paragraph tag from body
		if (isset($this->data[$this->alias]['body']) && !empty($this->data[$this->alias]['body'])) {

			$this->data[$this->alias]['body'] = preg_replace("/(<p[^>]*>[\s|&nbsp;]*<\/p>\n?)*$/", '', $this->data[$this->alias]['body']);
		}

		return parent::beforeSave($options);
	}

}