<?php

App::uses('CopyableBehavior', 'EvCore.Model/Behavior');

/**
 * Custom Copyable Behaviour
 *
 * Extends the Copyable Behaviour maintained by Mike to unload routable and navigatable copy. Also
 * adds support for setting the copy recusions level per model.
 */
class CustomCopyableBehavior extends CopyableBehavior {

	public function copy($Model, $id, $recurse_level = null)
	{
		$Model->Behaviors->unload('Routable.Routable');
		$Model->Behaviors->unload('Navigation.Navigatable');

		if (! $recurse_level) {
			$recurse_level = $this->settings[$Model->alias]['recurse_level'];
		}

		return parent::copy($Model, $id, $recurse_level);
	}

}