<?php

App::uses('CakeEventListener', 'Event');
App::uses('CustomEmail', 'Lib');

class EvUserPasswordResetListener implements CakeEventListener {

	public function implementedEvents() {

		return array(
			'Model.User.passwordReset' => 'sendPasswordResetEmail',
		);

	}


	public function sendPasswordResetEmail(CakeEvent $event) {

		// send the email
		$Email = new CustomEmail();

		$Email->template('password_reset_email');
		$Email->to($event->data['User'][$event->data['Model']]['email']);
		$Email->from(array(Configure::read('SiteSetting.admin_email') => Configure::read('SiteSetting.site_title')));
		$Email->subject(Configure::read('SiteSetting.site_title') . ' Password Reset');
		$Email->viewVars(array(
			'user' => $event->data['User'],
			'code' => $event->data['code'],
			'url' => $event->data['url']
		));
		$Email->helpers(array(
				'Html'
		));
		$Email->send();

		return;

	}

}