<?php
/**
 * Static content controller.
 *
 * This file will render views from views/pages/
 *
 * PHP 5
 *
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright 2005-2012, Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright 2005-2012, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       app.Controller
 * @since         CakePHP(tm) v 0.2.9
 * @license       MIT License (http://www.opensource.org/licenses/mit-license.php)
 */

App::uses('AppController', 'Controller');

/**
 * Static content controller
 *
 * Override this controller by placing a copy in controllers directory of an application
 *
 * @package       app.Controller
 * @link http://book.cakephp.org/2.0/en/controllers/pages-controller.html
 */
class EvPagesController extends AppController {

/**
 * Controller name
 *
 * @var string
 */
	public $name = 'Pages';

	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow(array(
			'home',
			'view'
		));
	}

	protected function _adminIndexColumns() {
		return array(
			'Page.id' => array(
				'label' => 'ID',
				'type' => 'integer',
			),
			'Page.title' => array(
				'label' => 'Title',
				'type' => 'string',
			),
			'Route.alias' => array(
				'label' => 'URL',
				'type' => 'string',
			),
			'Page.is_active' => array(
				'label' => 'Active',
				'type' => 'boolean'
			),
			'Page.created' => array(
				'label' => 'Created',
				'type' => 'datetime'
			),
			'Page.modified' => array(
				'label' => 'Modified',
				'type' => 'datetime'
			)
		);
	}

	protected function _adminFormFields() {
		return array(
			'Page.created' => array(
				'type' => 'text'
			),
			'Page.modified' => array(
				'type' => 'text'
			),
			'Page.id' => array(
				'type' => 'hidden'
			),
			'Page.title' => array(
				'type' => 'string'
			),
			'Route.id' => array(
				'type' => 'hidden'
			),
			'Route.alias' => array(
				'type' => 'slug'
			),
			'Page.body' => array(
				'type' => 'html'
			),
			'Page.is_active' => array(
				'type' => 'boolean'
			)
		);
	}

/**
 * Displays a view
 *
 * @param mixed What page to display
 * @return void
 */
	public function display() {
		$path = func_get_args();

		$count = count($path);
		if (!$count) {
			$this->redirect('/');
		}
		$page = $subpage = $title_for_layout = null;

		if (!empty($path[0])) {
			$page = $path[0];
		}
		if (!empty($path[1])) {
			$subpage = $path[1];
		}
		if (!empty($path[$count - 1])) {
			$title_for_layout = Inflector::humanize($path[$count - 1]);
		}
		$this->set(compact('page', 'subpage', 'title_for_layout'));
		$this->render(implode('/', $path));
	}

/**
 * Method required by CakePHP. You can ignore this.
 */
	public function home() {
	}

	public function view($id) {
		$data = $this->Page->readForView($id);

		if (empty($data['Page'])) {
			throw new NotFoundException();
		}

		$this->set('data', $data);
		$this->Meta->set($data);
		$this->view = 'view';

		// Check if we're overriding the view template.
		if (!empty($data['Page']['view_template'])) {

			$this->view = $data['Page']['view_template'];

			// Check if we need to grab any extra data for this template.
			$template = Inflector::camelize($data['Page']['view_template']);
			if (method_exists($this, '_get' . $template . 'Extras')) {
				$method = '_get' . $template . 'Extras';
				$this->$method();
			}
		}

		return;
	}

}
