<?php

/**
 * Business rules for Pages
 */
class Page extends AppModel {

	public $displayField = 'title';

	public $actsAs = array(
		'Routable.Routable' => array(
			'config' => 'EvCore'
		),
		'MetaData.Meta',
		'EvNavigation.Navigatable',
		'EvTemplates.Template' => array(
			'formInject' => true
		)
	);

	public $validate = array(
		'title' => array(
			'required' => array(
				'rule' => 'notBlank',
				'message' => 'cannot be blank'
			)
		)
	);

/**
 * Model pre-save logic
 */
	public function beforeSave($options = array()) {
		// remove trailing empty paragraph tag from body
		if (isset($this->data[$this->alias]['body']) && !empty($this->data[$this->alias]['body'])) {

			$this->data[$this->alias]['body'] = preg_replace("/(<p[^>]*>[\s|&nbsp;]*<\/p>\n?)*$/", '', $this->data[$this->alias]['body']);
		}

		return parent::beforeSave($options);
	}

}