<?php

App::uses('DocumentsController', 'EvCore.Controller');

/**
 * Handles image requests
 *
 * @package CoreCMS/Image
 */
class ImagesController extends DocumentsController {

	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow(array('get_image', 'generate_image'));

		return;
	}

/**
 * Add a new image slot via AJAX.
 *
 * @param string $model The model to link the image to e.g. Page
 * @param integer $key Image slot number
 * @param string $type
 * @param string $prefix Used when embedding images multiple levels deep e.g. Hotel.Room.0.Image
 * @param string $plugin
 * @param string $fields 	Comma separated list of fields
 */
	public function ajax_add($model, $key = 0, $type = 'Image', $prefix = "", $plugin = "", $itemFields = "") {
		$slotType = str_replace("Image", "", $type);

		if ($prefix == "" || $prefix == "false") {
			$prefix = $slotType;
		}

		if ($slotType == "") {
			$slotType = 'main';
		}

		if (! empty($plugin) && $plugin !== 'false') {
			$this->loadModel($plugin . "." . $model);
		} else {
			$this->loadModel($model);
		}

		$fields = false;
		if (! empty($itemFields) && $itemFields !== "false") {

			$fields = explode(',', $itemFields);
		} else {
			if (
				isset($this->$model->imageSlots[Inflector::underscore($slotType)]) &&
				is_array($this->$model->imageSlots[Inflector::underscore($slotType)]['fields']) &&
				array_key_exists('fields', $this->$model->imageSlots[Inflector::underscore($slotType)])
			) {

				$fields = $this->$model->imageSlots[Inflector::underscore($slotType)]['fields'];

			}
		}

		if (isset($this->{$model}->imageSlots[Inflector::underscore($slotType)]['fields']) && is_array($fields)) {
			$availableFields = $this->{$model}->imageSlots[Inflector::underscore($slotType)]['fields'];
			// Check the model to see if any of the fields have custom field settings defined.
			foreach ($fields as $fieldKey => $field) {

				if (isset($availableFields[$field]) && is_array($availableFields[$field])) {
					unset($fields[$fieldKey]);
					$fields[$field] = $availableFields[$field];

				}
			}
		}

		$this->set(compact('model', 'prefix', 'key', 'type', 'fields'));
		$this->theme = "Admin";
		$this->render('ajax_add', 'ajax');

		return;
	}

	/**
	 * Returns a preview image for ajax calls.
	 *
	 * @param integer $id ID of image to return
	 * @param integer $width Width of image to return
	 * @param integer $height Height of image to return
	 */
	public function ajax_preview($id, $width = 260, $height = 195) {
		$image = $this->Image->findById($id);

		$this->set(compact('image', 'width', 'height'));

		$this->theme = "Admin";

		$this->render('ajax_preview', 'ajax');

		return;
	}

	/**
	 * Change the sequence of a document.
	 *
	 * @param int $id file to be reordered
	 * @param string $direction direction to reorder, up or down
	 */
	public function ajax_reorder($id, $direction = 'down') {
		// Model name
		$Model = $this->{$this->modelClass};

		$this->set('model', $Model->alias);

		// Fetch the currenct document
		$currentDocument = $Model->findById($id);

		if (!empty($currentDocument)) {

			// Find the relevant adjacent document
			if ($direction == 'down') {
				$order = "sequence ASC";
			} else {
				$order = "sequence DESC";
			}

			$direction = $direction == 'down' ? '>' : '<';

			$params = array(
				'conditions' => array(
					'id <>' => $id,
					'model' => $currentDocument[$Model->alias]['model'],
					'model_id' => $currentDocument[$Model->alias]['model_id'],
					'attachment_type' => $currentDocument[$Model->alias]['attachment_type'],
					"sequence $direction" => $currentDocument[$Model->alias]['sequence']
				),
				'order' => $order
			);

			$adjacentDocument = $Model->find('first', $params);

			if (! empty($adjacentDocument)) {
				// Swap the sequence numbers of the current and adjacent documents

				$data = array(
					array(
						'id' => $id,
						'sequence' => $adjacentDocument[$Model->alias]['sequence']
					),
					array(
						'id' => $adjacentDocument[$Model->alias]['id'],
						'sequence' => $currentDocument[$Model->alias]['sequence']
					)
				);

				$Model->saveMany($data);
			}

			$this->set(compact('currentDocument', 'adjacentDocument'));
		}

		$this->theme = "Admin";

		$this->render('ajax_reorder', 'ajax');

		return;
	}

	/**
	 * Returns an image URL in the View.
	 *
	 * @param integer $imageId
	 * @param integer $width
	 * @param integer $height
	 * @return void
	 */
	public function generate_image($imageId, $width = null, $height = null) {
		$image = $this->Image->findById($imageId);

		$width = !empty($width) ? $width : null;
		$height = !empty($height) ? $height : null;

		$this->set(compact('image', 'width', 'height'));

		return $this->render('image', 'ajax');
	}

	/**
	 * Returns an image from the database.
	 *
	 * @param integer $imageId
	 * @param integer $width
	 * @param integer $height
	 * @return void
	 */
	public function get_image($imageId, $width = null, $height = null) {
		$image = $this->requestAction('/ev_core/images/generate_image/' . $imageId . '/' . $width . '/' . $height);
		$this->redirect($image);
		die();
	}
}