<?php

/**
 *
 */
class DocumentsController extends AppController {

/**
 * Add a new document slot via AJAX.
 *
 * @param string $model The model to link the document to e.g. Page
 * @param integer $key Document slot number
 * @param string $type
 * @param string $prefix Used when embedding documents multiple levels deep e.g. Hotel.Room.0.Document
 * @param string $plugin
 * @param string $fields 	Comma separated list of fields
 */
	public function ajax_add($model, $key = 0, $type = 'Document', $prefix = "", $plugin = "", $itemFields = "") {
		$slotType = str_replace("Document", "", $type);

		if ($prefix == "" || $prefix == "false") {
			$prefix = $slotType;
		}

		if ($slotType == "") {
			$slotType = 'main';
		}

		if (! empty($plugin) && $plugin !== 'false') {
			$this->loadModel($plugin . "." . $model);
		} else {
			$this->loadModel($model);
		}

		$fields = false;
		if (! empty($itemFields) && $itemFields !== "false") {

			$fields = explode(',', $itemFields);
		} else {
			if (isset($this->$model->documentSlots[Inflector::underscore($slotType)])) {
				if (isset($this->$model->documentSlots[Inflector::underscore($slotType)]['fields'])) {
					$fields = $this->$model->documentSlots[Inflector::underscore($slotType)]['fields'];
				}
			}
		}

		if (isset($this->{$model}->documentSlots[Inflector::underscore($slotType)]['fields']) && is_array($fields)) {
			$availableFields = $this->{$model}->documentSlots[Inflector::underscore($slotType)]['fields'];
			// Check the model to see if any of the fields have custom field settings defined.
			foreach ($fields as $fieldKey => $field) {

				if (isset($availableFields[$field]) && is_array($availableFields[$field])) {
					unset($fields[$fieldKey]);
					$fields[$field] = $availableFields[$field];

				}
			}
		}

		$this->set(compact('model', 'prefix', 'key', 'type', 'fields'));

		$this->theme = "Admin";

		$this->render('ajax_add', 'ajax');

		return;
	}

	/**
	 * Removes a document
	 *
	 * @param int $id file to be removed
	 */
	public function ajax_remove($id) {
		// Model name
		$Model = $this->{$this->modelClass};

		$this->render(false, false);

		return $Model->delete($id);
	}

	/**
	 * Change the sequence of a document
	 *
	 * @param int $id file to be reordered
	 * @param string $direction direction to reorder, up or down
	 */
	public function ajax_reorder($id, $direction = 'down') {
		// Model name
		$Model = $this->{$this->modelClass};

		$this->set('model', $Model->alias);

		// Fetch the currenct document
		$currentDocument = $Model->findById($id);

		if (!empty($currentDocument)) {

			// Find the relevant adjacent document

			$direction = $direction == 'down' ? '>' : '<';

			$params = array(
				'conditions' => array(
					'id <>' => $id,
					'model' => $currentDocument[$Model->alias]['model'],
					'model_id' => $currentDocument[$Model->alias]['model_id'],
					"sequence $direction" => $currentDocument[$Model->alias]['sequence']
				)
			);

			$adjacentDocument = $Model->find('first', $params);

			if (!empty($adjacentDocument)) {

				// Swap the sequence numbers of the current and adjacent documents

				$data = array(
					array(
						'id' => $id,
						'sequence' => $adjacentDocument[$Model->alias]['sequence']
					),
					array(
						'id' => $adjacentDocument[$Model->alias]['id'],
						'sequence' => $currentDocument[$Model->alias]['sequence']
					)
				);

				$Model->saveMany($data);

			}

			$this->set(compact('currentDocument', 'adjacentDocument'));
		}

		$this->render('../../Admin/Documents/ajax_reorder', 'ajax');

		return;
	}

}