<?php
class AddedCreatedModifiedFields extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'Added_created_modified_fields';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'user_groups' => array(
					'is_active' => array('type' => 'boolean', 'null' => true, 'default' => '0', 'after' => 'name'),
					'created' => array('type' => 'datetime', 'null' => true, 'default' => null, 'after' => 'is_active'),
					'modified' => array('type' => 'datetime', 'null' => true, 'default' => null, 'after' => 'created'),
				),
				'users' => array(
					'created' => array('type' => 'datetime', 'null' => true, 'default' => null, 'after' => 'password_reset_code_expires'),
					'modified' => array('type' => 'datetime', 'null' => true, 'default' => null, 'after' => 'created'),
				),
			),
		),
		'down' => array(
			'drop_field' => array(
				'user_groups' => array('is_active', 'created', 'modified'),
				'users' => array('created', 'modified'),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
