<?php

App::uses('Attachment', 'EvCore.Model');

/**
 * Document attachments.
 */
class Document extends Attachment {

/**
 * Number of document slots for the current model.
 */
	public $documentSlots = 0;

/**
 * Defines number of image slots for the current model.
 */
	public $imageSlots = 0;

	public $virtualFields = array(
		'filepath' => 'CONCAT("files/document/", id, "/", filename)'
	);

	public $actsAs = array(
		'Upload.Upload' => array(
			'filename' => array(
				'path' => '{ROOT}webroot{DS}files{DS}document{DS}',
				'nameCallback' => 'fixUploadFilename'
			)
		)
	);

/**
 * @see Attachment::beforeSave()
 */
	public function beforeSave($options) {
		// We want to store the file extension of documents in addition to the
		// file type. This is useful for displaying file icons in the views.
		if (isset($this->data[$this->alias]['filename']) && !empty($this->data[$this->alias]['filename'])) {

			preg_match('|.([A-Za-z0-9]+)$|', $this->data[$this->alias]['filename'], $matches);
			if ($matches) {
				$this->data[$this->alias]['ext'] = strtolower($matches[1]);
			}

		}

		return parent::beforeSave($options);
	}

	/**
 	* @see AppModel::beforeDelete()
 	*/
	public function beforeDelete($cascade = true) {
		// It's important we check the parent hasn't returned false before
		// proceeding.
		if (!parent::beforeDelete($cascade)) {
			return false;
		}

		$data = $this->findById($this->id);

		$success = true;

		// Remove file before we delete the attachment record.
		if (!empty($data[$this->alias]) && file_exists($data[$this->alias]['filepath'])) {

			$success = unlink($data[$this->alias]['filepath']) && rmdir('files/document/' . $data[$this->alias]['dir']);

		}

		return $success;
	}
}
