<?php

App::uses('DocumentsController', 'EvCore.Controller');

/**
 * Handles image requests
 *
 * @package CoreCMS/Image
 */
class ImagesController extends DocumentsController {

/**
 * Add a new image slot via AJAX.
 *
 * @param string $model The model to link the image to e.g. Page
 * @param integer $key Image slot number
 * @param string $type
 * @param string $prefix Used when embedding images multiple levels deep e.g. Hotel.Room.0.Image
 * @param string $plugin
 */
	public function ajax_add($model, $key=0, $type='Image', $prefix="", $plugin="") {

		$slotType = str_replace("Image", "", $type);

		if ($prefix == "" || $prefix == "false") {
			$prefix = $slotType;
		}

		if ($slotType == "") {
			$slotType = 'main';
		}

		if ($plugin != "") {
			$this->loadModel($plugin.".".$model);
		} else {
			$this->loadModel($model);
		}


		if (isset($this->$model->imageSlots[Inflector::underscore($slotType)])) {
			if (isset($this->$model->imageSlots[Inflector::underscore($slotType)]['fields'])) {
				$fields = $this->$model->imageSlots[Inflector::underscore($slotType)]['fields'];
			} else {
				$fields = true;
			}
		} else {
			$fields = true;
		}

		$this->set(compact('model', 'prefix', 'key', 'type', 'fields'));

		$this->theme = "Admin";

		$this->render('ajax_add', 'ajax');

		return;

	}


/**
 * Returns a preview image for ajax calls.
 *
 * @param integer $id ID of image to return
 * @param integer $width Width of image to return
 * @param integer $height Height of image to return
 */
	public function ajax_preview($id, $width = 260, $height = 195) {

		$data = $this->Image->findById($id);

		$image = "/".$data['Image']['filepath'];

		$this->set(compact('image', 'width', 'height'));

		$this->theme = "Admin";

		$this->render('ajax_preview', 'ajax');

		return;

	}

/**
 * Change the sequence of a document.
 *
 * @param int $id file to be reordered
 * @param string $direction direction to reorder, up or down
 */
	public function ajax_reorder($id, $direction='down') {


		// Model name
		$Model = $this->{$this->modelClass};

		$this->set('model', $Model->alias);

		// Fetch the currenct document
		$currentDocument = $Model->findById($id);

		if (!empty($currentDocument)) {

			// Find the relevant adjacent document
			if($direction=='down') {
				$order = "sequence ASC";
			} else {
				$order = "sequence DESC";
			}

			$direction = $direction=='down' ? '>' : '<';

			$params = array(
				'conditions' => array(
					'id <>' => $id,
					'model' => $currentDocument[$Model->alias]['model'],
					'model_id' => $currentDocument[$Model->alias]['model_id'],
					'attachment_type' => $currentDocument[$Model->alias]['attachment_type'],
					"sequence $direction" => $currentDocument[$Model->alias]['sequence']
				),
				'order' => $order
			);

			$adjacentDocument = $Model->find('first', $params);

			if (!empty($adjacentDocument)) {

				// Swap the sequence numbers of the current and adjacent documents

				$data = array(
					array(
						'id' => $id,
						'sequence' => $adjacentDocument[$Model->alias]['sequence']
					),
					array(
						'id' => $adjacentDocument[$Model->alias]['id'],
						'sequence' => $currentDocument[$Model->alias]['sequence']
					)
				);

				$Model->saveMany($data);

			}

			$this->set(compact('currentDocument', 'adjacentDocument'));

		}

		$this->theme = "Admin";

		$this->render('ajax_reorder', 'ajax');

		return;

	}

}