<?php
/**
 * Routes configuration
 *
 * Used to set up the routes used by the Evoluted CMS 
 * 
 * 
 *
 * PHP 5
 *
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright 2005-2012, Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright 2005-2012, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       app.Config
 * @since         CakePHP(tm) v 0.2.9
 * @license       MIT License (http://www.opensource.org/licenses/mit-license.php)
 */
	
	Router::connect('/admin/user_groups/add', array(
		'plugin' => 'ev_core',
		'controller' => 'user_groups',
		'admin' => true,
		'action' => 'edit'
	));
	
	Router::connect('/admin/:plugin/:controller/add', array(
		'action' => 'edit',
		'admin' => true
	));
	Router::connect('/admin/menus/add', array(
		'plugin' => 'navigation',
		'controller' => 'menus',
		'action' => 'edit',
		'admin' => true
	));
	Router::connect('/admin/:controller/add', array(
		'action' => 'edit',
		'admin' => true
	));
	

/*
 * Image and Document routes 
 */
	Router::connect('/ajax/images/:action/*', array(
		'plugin' => 'ev_core',
		'controller' => 'images',
		'ajax' => true
	));


	Router::connect('/ajax/documents/:action/*', array(
		'plugin' => 'ev_core',
		'controller' => 'documents',
		'ajax' => true
	));


/*
 * User Routes
 */

	Router::connect('/admin/user_groups', array(
		'plugin' => 'ev_core',
		'controller' => 'user_groups',
		'action' => 'index',
		'admin' => true
	));

	Router::connect('/admin/user_groups/:action/*', array(
		'plugin' => 'ev_core',
		'controller' => 'user_groups',
		'admin' => true
	));


/*
 * Countries routes
 */

	Router::connect('/admin/countries', array(
		'plugin' => 'ev_core',
		'controller' => 'countries',
		'action' => 'index',
		'admin' => true
	));

	Router::connect('/admin/countries/:action/*', array(
		'plugin' => 'ev_core',
		'controller' => 'countries',
		'admin' => true
	));


/* 
 * Admin Controller - just dashboard
 */
	
	Router::connect('/admin', array(
		'plugin' => 'ev_core',
		'controller' => 'admin',
		'action' => 'index',
		'admin' => true
	));
