<?php

App::uses('CopyableBehavior', 'EvCore.Model/Behavior');

/**
 *
 */

class CustomCopyableBehavior extends CopyableBehavior {

	/**
	 *
	 */
	public function copy($Model, $id, $recurse_level = 1) {

		$Model->Behaviors->unload('Routable.Routable');
		$Model->Behaviors->unload('Navigation.Navigatable');
		
		return parent::copy($Model, $id, $recurse_level);

	}


	/**
	 * Loops through any HABTM results in $this->record and plucks out
	 * the join table info, stripping out the join table primary
	 * key and the primary key of $Model. This is done instead of
	 * a simple collection of IDs of the associated records, since
	 * HABTM join tables may contain extra information (sorting
	 * order, etc).
	 *
	 * @param object $Model    Model object
	 * @access public
	 * @return array modified $record
	 */
	private function __convertHabtm($Model, $record) {

		if (!$this->settings[$Model->alias]['habtm']) {
			return $record;
		}

		foreach ($Model->hasAndBelongsToMany as $key => $val) {

			// check whether a custom relationship is used, if so then
			// overwrite the $val['className']
			if ($key != $val['className']) {

				$val['className'] = $key;

			}

			if (!isset($record[$val['className']]) || empty($record[$val['className']])) {
				continue;
			}

			$joinInfo = Set::extract($record[$val['className']], '{n}.'.$val['with']);

			if (empty($joinInfo)) {
				continue;
			}

			foreach ($joinInfo as $joinKey => $joinVal) {
				$joinInfo[$joinKey] = $this->__stripFields($Model, $joinVal);

				if (array_key_exists($val['foreignKey'], $joinVal)) {
					unset($joinInfo[$joinKey][$val['foreignKey']]);
				}
			}

			$record[$val['className']] = $joinInfo;
		}

		return $record;
	}

}