<?php

abstract class Attachment extends AppModel {

/**
 * Number of document slots for the current model.
 */
	public $documentSlots = 0;

/**
 * Defines number of image slots for the current model.
 */
	public $imageSlots = 0;

	public $order = array(
		'sequence' => 'ASC'
	);


/**
 * @see AppModel::beforeSave()
 */
	public function beforeSave($options = array()){

		if (!parent::beforeSave($options)) {
			return false;
		}

		// Insert sequence number if creating an attachment.
		if (empty($this->id) && empty($this->data[$this->alias]['sequence'])) {

			$this->data[$this->alias]['sequence'] = $this->getNextSequenceNo(array(
					'conditions' => array(
						'model' => $this->data[$this->alias]['model'],
						'model_id' => $this->data[$this->alias]['model_id'],
						'attachment_type' => $this->data[$this->alias]['attachment_type'],
					)
				)
			);

		}

		return true;

	}


/**
 * @see AppModel::beforeDelete()
 */
	public function beforeDelete($cascade = true) {

		// It's important we check the parent hasn't returned false before
		// proceeding.
		if (!parent::beforeDelete($cascade)) {
			return false;
		}

		$data = $this->findById($this->id);

		$success = true;

		// Remove file before we delete the attachment record.
		if (!empty($data[$this->alias]) && file_exists($data[$this->alias]['filepath'])) {

			$success = unlink($data[$this->alias]['filepath']) && rmdir('files/image/'.$data[$this->alias]['dir']);

		}

		return $success;

	}

}