<?php
App::uses('EvContactInfoAppModel', 'EvContactInfo.Model');
/**
 * Contact Model
 *
 * @property ContactDatum $ContactDatum
 */
class Contact extends EvContactInfoAppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'label';


	//The Associations below have been created with all possible keys, those that are not needed can be removed

/**
 * hasMany associations
 *
 * @var array
 */
	public $hasMany = array(
		'ContactDatum' => array(
			'className' => 'EvContactInfo.ContactDatum',
			'foreignKey' => 'contact_id',
			'dependent' => true,
			'cascade' => true
		)
	);

	public function afterFind($results, $primary = false)
	{
		if (! isset($results['0']['ContactInfo'])) {

			return $results;
		}

		$return = array();
		$data_id = array();

		foreach ($results as $row) {

			$data_id[] = $row['ContactInfo']['id'];

			$return[$row['ContactInfo']['id']] = array(
				'ContactInfo' => array(
					'model' => $row['ContactInfo']['model'],
					'model_id' => $row['ContactInfo']['model_id'],

					'Contact' => $row['ContactInfo'],
					'ContactDatum' => array()
				)
			);
		}

		$data = $this->ContactDatum->find('all', array(
			'conditions' => array(
				'ContactDatum.contact_id' => $data_id
			),
			'order' => 'ContactDatum.id ASC'
		));
		$data = Hash::combine($data, '{n}.ContactDatum.id', '{n}.ContactDatum');

		foreach ($data as $datum) {

			if (isset($return[$datum['contact_id']])) {

				$return[$datum['contact_id']]['ContactInfo']['ContactDatum'][] = $datum;
			}
		}

		// reset array to have normal keys otherwise whole process doesn't work
		$results = array();
		foreach ($return as $data) {

			$results[] = $data;
		}

		return $results;
	}

	/**
	 * get the related contact info
	 *
	 * @param string 	model name to look for
	 * @param int 		model id to look for
	 * @return array 	array of contact info data
	 */
	public function getContactData($model, $model_id)
	{
		return $this->find('all', array(
			'conditions' => array(
				'Contact.model' => $model,
				'Contact.model_id' => $model_id
			),
			'order' => 'Contact.id ASC',
			'contain' => array(
				'ContactDatum'
			)
		));
	}

}
