<?php

App::uses('Contact', 'EvContactInfo.Model');

class ContactInfoBehavior extends ModelBehavior
{
	public function setup(Model $Model, $settings = array())
	{
		parent::setup($Model, $settings);

		$Model->hasMany['ContactInfo'] = array(
			'className' => 'EvContactInfo.Contact',
			'foreignKey' => 'model_id',
			'conditions' => array(
				'ContactInfo.model' => $Model->alias
			)
		);
	}

	/**
	 * beforeSave behaviour callback,
	 * Delete any existing contact info blocks
	 */
	public function beforeSave(Model $Model, $options=array())
	{
		$return = parent::beforeSave($Model, $options);

		$Contact = new Contact;

		$Contact->deleteAll(
			array(
				'Contact.model' => $Model->alias,
				'Contact.model_id' => (isset($Model->data[$Model->alias]['id'])) ? $Model->data[$Model->alias]['id'] : 0
			)
		);

		return $return;
	}

	/**
	 * afterSave behaviour Callback
	 * Save all the contact data found in the array
	 */
	public function afterSave(Model $Model, $created, $options=array())
	{
		$return = parent::afterSave($Model, $created, $options);

		$contact_data = $Model->data[$Model->alias]['Contact'];

		foreach ($contact_data as $key => $contact) {

			$contact_data[$key]['model'] = $Model->alias;
			$contact_data[$key]['model_id'] = $Model->id;
		}

		$Contact = new Contact;
		$Contact->create();
		$Contact->saveAll($contact_data, array(
			'deep' => true
		));

		return $return;
	}

	/**
	 * find an inject any related contact data
	 */
	public function afterFind(Model $Model, $data, $primary=false)
	{
		$Contact = new Contact;

		foreach ($data as $id => $item) {

			$data[$id]['ContactInfo'] = $Contact->getContactData(
				$Model->alias,
				(isset($item[$Model->alias]['id'])) ? $item[$Model->alias]['id'] : 0
			);
		}

		return $data;
	}


}