<div class="ev-contact-form">
	<?php
		echo $this->Session->flash('ev_contact_form');

		$form['form']['class'] .= ' disable-button-during-submit';
		$form['form']['type'] = 'file';

		echo $this->Form->create('EvContactForm.' . $name, $form['form']);

		// a custom form submit check field
		echo $this->Form->hidden('contact-form-send', array('value' => $name));

		//Check if there is overriding content
		$formFields = $this->fetch('formFields');
	?>

	<?php if (!empty($formFields)): ?>
		<?= $formFields ?>
	<?php else: ?>
		<?php if (isset($form['fieldset']) && $form['fieldset'] == true): ?>
			<?= $this->Html->tag('fieldset', null) ?>

			<?php if (!empty($form['fieldset_message'])): ?>
				<?php if (is_array($form['fieldset_message'])): ?>
					<?php
						switch ($form['fieldset_message']['source']):
							case 'site_settings':
								echo Configure::read('SiteSetting.EvContactForm.' . $form['fieldset_message']['identifier']);
								break;

							default: // unsupported data source
								error_log('Invalid data source specified for fieldset message');
								break;
						endswitch;
					?>
				<?php else: ?>
					<?= $this->Html->tag('p', $form['fieldset_message']) ?>
				<?php endif; ?>
			<?php endif; ?>
		<?php endif; ?>

		<?php if (! empty($form['legend'])): ?>
			<?= $this->Html->tag('legend', $form['legend']) ?>
		<?php endif; ?>

		<?php if (!empty($form['fields'])): ?>
			<?php foreach ($form['fields'] as $field => $attr): ?>
				<?php if (!empty($form['use_field_sections']) && $field == 'contact_form_sections'): ?>
					<?php foreach ($attr as $sectionName => $section): ?>
						<div class="ev-contact-form__section" data-contact-form-section="<?= h($sectionName) ?>">
							<?php if (!empty($form['use_field_groups']) && !empty($section['contact_form_groups'])): ?>
								<?php foreach ($section['contact_form_groups'] as $groupName => $group): ?>
									<div class="ev-contact-form__group" data-contact-form-group="<?= h($groupName) ?>">
										<?php if (!empty($group['fields'])): ?>
											<?php foreach ($group['fields'] as $groupField => $groupAttr): ?>
												<?= $this->ShowContactForm->displayField($groupField, $groupAttr, $form['use_inline_errors']) ?>
											<?php endforeach; ?>
										<?php endif; ?>
									</div>
								<?php endforeach ?>
							<?php endif; ?>

							<?php if (!empty($section['fields'])): ?>
								<?php foreach ($section['fields'] as $sectionField => $sectionAttr): ?>
									<?= $this->ShowContactForm->displayField($sectionField, $sectionAttr, $form['use_inline_errors']) ?>
								<?php endforeach; ?>
							<?php endif; ?>
						</div>
					<?php endforeach; ?>
				<?php else: ?>
					<?= $this->ShowContactForm->displayField($field, $attr, $form['use_inline_errors']) ?>
				<?php endif; ?>
			<?php endforeach; ?>
		<?php endif; ?>
	<?php endif; ?>

	<?php
    	// assign the google adwords tracking code when the cookie exists
    	// and we're looping over the correct form element
		if (
			!empty(Configure::read('SiteSetting.general.google_analytics'))
			&& Configure::read('app.environment') !== 'DEVELOPMENT'
		):
	    	if (! empty($adwordsGclid)):

	    		$adwordsGclid = explode('</>', $adwordsGclid);
				$commaSeparatedIds = '';

	    		foreach ($adwordsGclid as $gclid) {
					if (empty($commaSeparatedIds)) {
						$commaSeparatedIds = $gclid;
					} else {
						$commaSeparatedIds .= ', ' . $gclid;
					}
	    		}

				$attr = array(
					'type' => 'hidden',
					'label' => 'Google Adwords Tracking',
					'admin-label' => 'Google Adwords Tracking',
					'div' => 'hidden',
					'value' => $commaSeparatedIds
				);
				echo $this->Form->addField('adwords_tracking', $attr);
	    	endif;
	    endif;

		// spam field :)
		echo $this->ShowContactForm->displaySpamField();

		//Submit Field
		if (!empty($form['submit']) && is_array($form['submit'])):
			echo $this->ShowContactForm->displaySubmit($name, $form['submit']);
		elseif (!isset($form['submit']) || $form['submit'] !== false):
			echo $this->ShowContactForm->displaySubmit($name);
		endif;

		//Close fieldset
		if (isset($form['fieldset']) && $form['fieldset'] == true):
			echo $this->Html->tag('/fieldset');
		endif;

		echo $this->Form->end();

		//CSS
		if (!isset($form['css']) || $form['css'] === true):
			echo $this->Html->css('EvContactForm.ev-contact-form');
		elseif (!empty($form['css'])):
			echo $this->Html->css($form['css']);
		endif;

		// silently output for validation errors to Google Analytics
		if (
			!empty(Configure::read('SiteSetting.general.google_analytics'))
			&& Configure::read('app.environment') !== 'DEVELOPMENT'
		):
			if (isset($name)):
				$errorName = $name . '_errors';
			endif;

			if (! empty($$errorName)):
				$gaErrorString = '';
				foreach ($$errorName as $gaError):
					$gaErrorString .= "ga('send', 'event', 'Errors', 'Validation Error', '$gaError');";
				endforeach;

				echo $this->Html->scriptBlock($gaErrorString);
			endif;
		endif;
	?>
</div>
