# EvContactForm

## Installation

- Run `composer require evoluted/contact-form` to pull in the latest version

## Set Up

- Configure the plugin and create some forms in `app/Config/Plugin/ev_contact_form.php` (you'll need to create this file). The `Config/config-fullsample.php` file in the plugin shows an example of the options available.

- To setup the database use the CakeDC Migrations plugin. To run the migrations and setup the database run:-

	```
	Console/cake Migrations.migration run all --plugin EvContactForm
	```

- Go to `/admin/contact-form/form` and create the contact forms, as many as you have defined in config. Set a `system_name` for each contact form so that you can easily fetch it for display in the controller (IDs work too, but it's easier to maintain across multiple environments if we use the `system_name`).

## Usage

### Controller

- Add to `$components`.

	```php
	'EvContactForm.InjectContactForm'
	```

- Add to `$helpers`.

	```php
	'EvContactForm.ShowContactForm'
	```

- In the view action in your controller where you want to show & process contact form use:

	```php
	$this->InjectContactForm->display($systemName, 'enquiry');
	```

	Where `$systemName` is the `system_name` of the contact form you have created in admin (or `id`), and `'enquiry'` is the name you choose. It posts using this, so make it unique.

- If you need to do this without overwriting what is already in `$components` or `$helpers` you can add them in the constructor:

	```php
	public function __construct($request = null, $response = null) {
		$this->components[] = 'EvContactForm.InjectContactForm';
		$this->helpers[] = 'EvContactForm.ShowContactForm';

		parent::__construct($request, $response);
	}
	```

	This is useful if you need to use `EvContactForm` with `EvCorePagesController`.

### View

Paste the following into the view template where you would like the form to display:

```php
<?= $this->ShowContactForm->display('enquiry') ?>
```

You can use the plugin's config file to configure how the form is rendered. If you need more flexibility then copy `contact_form.ctp` from `EvContactForm/View/Elements` to your App's `View/Elements` directory.

#### Flash and Validation Errors

There are two options to choose from when showing Flash messages and form validation errors and can be controlled by toggling the `use_inline_errors` flag on each form.

The flag should be left as `false` to display a default Flash message above the form containing an unordered list of validation errors.

Toggling the field to `true` will stop the Flash message and will show form validation messages underneath each failing form element.

### Success and Redirects
Once a successful submission has been made you can have the system redirect the user to another page. This is done by editing the `success_redirect` parameter in the plugin config. This currently accepts:
- A standard CakePHP route array where you define controller, action etc
- A literal URL
- "true", which will redirect back to the page the form is on
- An array featuring the key `internal_title` which will look up and redirect to the page with the matching internal title (will throw a NotFoundException if it doesn't exist)

### File Uploads
From version 2.2.8.0 you can add a file upload option to your contact form. This simply needs a file field type, and an example of its usage can be found in the `config-fullsample.php` file. Documents are then made viewable in read-only mode when viewing the contact form response in the admin area.

You can also attach these files to the notification email by enabling the `EvContactForm.attach_files_to_notification_email` setting. There is also an optional `EvContactForm.notification_email_attachments_max_filesize` setting that you can use to define the maximum combined filesize of the attachments; this is useful to ensure that nothing too big is attached to the email (it doesn't affect what can be uploaded to the enquiry). The notification email will contain links to the attachments when `EvContactForm.attach_files_to_notification_email` is set to `true` as well as attempting to attach them.

### Admin notification emails

By default admin notification emails are sent from the admin email address and site name set in the Site Settings. To override this you can add the following to the config:

	'admin_email_notification' => [
		'from' => [
			'email' => 'admin@evoluted.net',
			'name' => 'Evoluted CMS'
		],
	],

There's an example in the `config-fullsample.php` file.

### Sending user emails
If you want to notify the user of the enquiry they have made by email then you need to add an extra setting to the form config.

	'user_email_notification' => true,

By default the subject is the site title and the email is sent from the site title with the admin's email address set up in the CMS site settings. If you would like to customise the subject or who the email is being sent from then you can use the following setting:

	'user_email_notification' => array(
		'from' => array(
			'email' => 'admin@evoluted.net',
			'name' => 'Evoluted CMS'
		),
		'subject' => 'Enquiry from evoluted CMS'
	),

### Modifying email notifications
Sometimes you may need to modify the notification emails in some manner. For example, on long forms the response may want to structured differently so a new template could be used or extra site details will need to be added through the view variables. This can be achieved with the `_modifyEmail()` function in the `InjectContactFormComponent` class. Extend the class and the function and use any function available on the Email object to do what you need.

The current email object is passed as reference so modifications can be made directly. The target, `'admin'` or `'user'` is also provided to make differentiations between who will be receiving the email. The form config itself is also passed through so you can add new config values for different forms. The current to/from address is provided along with the subject that was used to setup the original email object for circumstances that may require them to modified.

# Conversion success tracking

A field has been added to the site settings (conversion success code) for storing Google tracking code and is echoed on form success:

	echo Configure::read('SiteSetting.tracking.conversion_success_code');

# Exporting Contact Forms

Using the EvMigrationUtil library, contact forms can be exported as a migration. To export to a migration use:

	app/Console/cake EvMigrationUtil.Migration export EvContactForm.ContactForm system_name

# Showing related data
If on your contact form it has a dropdown field which contains foreign data from a different model, you can provide
the `model` config to that fields config along which allows you to specify the related model and the field that is
being used to as the human friendly value of the dropdown. When used, it'll change the value of the field in the CMS
to either the value of the `fieldToShow` field or the display field set against the model.

### Contact Form Templates
If the structure of a contact form is outside the bounds of what can be made with the config then a custom template can be made instead. To enable the use of a template, in the form config use the config key `template` to set a filepath of an element to use in the place of `EvContactForm.contact_form.ctp`. The element should extend from the plugin (`<?php $this->extends('EvContactForm.contact_form'); ?>`) and the custom form should go inside a `formFields` view block (`<?php $this->start('formFields'); ?>`). If you are unfamiliar with view blocks then these docs can help https://book.cakephp.org/2.0/en/views.html#using-view-blocks. The parent element provides the start of the form so you do not need to start it again. Fields will need to be prefixed with the name of the form, which is available in the variable `$name`. An example of how to use a custom contact form is available in the element `EvContactForm.custom_example_template.ctp`.

## Spam Detection
The plugin comes with basic spam detection out of the box. A hidden field is added asking for email confirmation that only bots would be able to populate. The contents of each field is also checked against a predefined list of characters and phrases that are regularly used in spam messages.

Although this will catch some spam bots, this will not catch all of them and it is recommended that a more sophisticated spam detection tool be used instead, for example adding recaptcha to the forms instead.

### Disabling default spam detection
In some scenarios you may want to disable the default spam detection. This is usually required when a contact form becomes more complex and needs to allow for a greater amount of flexibility in content that users may enter, [see wiki for examples.](https://en.wikipedia.org/wiki/Scunthorpe_problem)

To disable the default spam detection, add the following setting to the form in the config file you want to disable it on:
`'skip_spam_detection' => true`

It is recommended that alternative methods of spam detection are found and implemented before this setting is enabled.
