<?php

App::uses('EvContactFormAppModel', 'EvContactForm.Model');

App::uses('ResponseFormatter', 'EvContactForm.Lib');

class ContactFormResponse extends EvContactFormAppModel {

	public $documentSlots = array(
		'files' => array(
			'fields' => array(),
			'slots' => -1
		)
	);

	public $belongsTo = array(
		'ContactForm' => array(
			'className' => 'EvContactForm.ContactForm'
		)
	);

/**
 * Query used to retrieve a record ready for admin view.
 *
 * @param int   $id     ID of row to edit.
 * @param array $params The db query array - can be used to pass in additional parameters such as contain.
 * @return array
 */
	public function readForAdminView($id = null, $params = array()) {
		$data = parent::readForAdminView($id, $params);

		if (empty($data[$this->alias]['contact_form_id'])) {
			return $data;
		}

		$formConfigName = $this->ContactForm->field(
			'form_data',
			[
				'id' => $data[$this->alias]['contact_form_id'],
			]
		);

		if (empty($formConfigName)) {
			return $data;
		}

		$formFields = Configure::read('EvContactForm.forms.' . $formConfigName . '.fields');

		if (empty($formFields)) {
			return $data;
		}

		// unserialise and manipulate form_data data ready to display
		$formData = unserialize($data[$this->alias]['form_data']);

		if (empty($formData)) {
			return $data;
		}

		$data[$this->alias] = array_merge(
			$data[$this->alias],
			$this->formatResponseData($formData, $formFields)
		);

		return $data;
	}

/**
 * Format a contact form response. Replace any related fields with their model values.
 *
 * @param array $data         The response form data in $field => $value format.
 * @param array $configFields The fields from the contact form config.
 * @return array Formatted data in $field => $value format.
 */
	public function formatResponseData($data, $configFields) {
		$responseFormatter = new ResponseFormatter();

		foreach ($data as $key => &$value) {
			if (empty($configFields[$key])) {
				//Field not found in config so don't format
				continue;
			}

			if (!empty($configFields[$key]['model']['name'])) {
				$RelatedModel = EvClassRegistry::init($configFields[$key]['model']['name']);

				$field = !empty($configFields[$key]['model']['fieldToShow']) ?
						$configFields[$key]['model']['fieldToShow'] :
						$RelatedModel->displayField;

				$value = $RelatedModel->field(
					$field,
					[
						$RelatedModel->primaryKey => $value,
					]
				);
			}

			$value = $responseFormatter->format($key, $configFields[$key], $value);
		}

		return $data;
	}
}
