<?php

App::uses('EvContactFormAppModel', 'EvContactForm.Model');

class ContactForm extends EvContactFormAppModel {

	public $hasMany = array(
		'ContactFormResponse' => array(
			'className' => 'EvContactForm.ContactFormResponse'
		)
	);

	public $validate = [
		'name' => [
			'required' => [
				'rule' => 'notBlank',
				'message' => 'Please provide a contact form name',
			],
		],
		'system_name' => [
			'required' => [
				'rule' => 'notBlank',
				'message' => 'Please provide a contact form system name',
			],
		],
		'form_data' => [
			'required' => [
				'rule' => 'notBlank',
				'message' => 'Please provide a select a contact form type',
			],
		],
	];
}
