<?php

App::uses('BaseMigrationModelUtil', 'EvMigrationUtil.Lib');

class ContactFormMigrationModelUtil extends BaseMigrationModelUtil {

/**
 * Exports a contact form to a migration
 *
 * @param int $systemName The system_name passed on the command line
 *
 * @return bool True on success
 * @throws NotFoundException If the contactForm item cannot be found
 */
	public function getExportMigration($systemName) {
		$migrationUp = PHP_EOL;
		$migrationDown = PHP_EOL;
		$migration = '';

		$migration .= '$ContactFormUtil = MigrationUtil::init(\'EvContactForm.ContactForm\');' . PHP_EOL;

		$contactForm = $this->Model->findBySystemName($systemName);
		if (empty($contactForm)) {
			throw new NotFoundException();
		}

		$migrationUp .= '$isActive = ' . $this->_migrationValue($contactForm['ContactForm']['is_active']) . ';' . PHP_EOL;

		$migrationUp .= '$ContactFormUtil->createOnce([' . PHP_EOL;
		$migrationUp .= '	\'system_name\' => ' . $this->_migrationValue($contactForm['ContactForm']['system_name']) . ',' . PHP_EOL;
		$migrationUp .= '], [' . PHP_EOL;
		foreach ($contactForm['ContactForm'] as $field => $value) {
			if (!in_array($field, ['id', 'is_active'])) {
				$migrationUp .= '	\'' . $field . '\' => ' . $this->_migrationValue($value) . ',' . PHP_EOL;
			}
		}
		$migrationUp .= '	\'is_active\' => $isActive,' . PHP_EOL;
		$migrationUp .= ']);' . PHP_EOL;

		// DOWN
		$migrationDown .= '$idToDelete = $ContactFormUtil->Model->field(\'ContactForm.id\', [\'ContactForm.system_name\' => ' . $this->_migrationValue($contactForm['ContactForm']['system_name']) . ']);' . PHP_EOL;
		$migrationDown .= '$ContactFormUtil->Model->delete($idToDelete);' . PHP_EOL;

		$return = [
			'common' => $migration,
			'up' => $migrationUp,
			'down' => $migrationDown,
		];

		return $return;
	}
}
