<?php

class FieldFormatter {

/**
 * Collate the contact form fields into sections and groups if the form config has them enabled and fields have the
 * correct attribute set.
 *
 * @param array $fields      Current contact form fields.
 * @param bool  $groupFields True if the fields should be group inside of sections.
 * @return array Modified fields array.
 */
	public function sectionAndGroupFields(array $fields, $groupFields = false) {
		foreach ($fields as $fieldName => $fieldAttr) {
			if (empty($fieldAttr['section'])) {
				continue;
			}

			$sectionName = $fieldAttr['section'];
			unset($fieldAttr['section']);

			if (empty($groupFields) || empty($fieldAttr['group'])) {
				$fields['contact_form_sections'][$sectionName]['fields'][$fieldName] = $fieldAttr;
				unset($fields[$fieldName]);
				continue;
			}

			$groupName = $fieldAttr['group'];
			unset($fieldAttr['group']);

			$fields['contact_form_sections'][$sectionName]['contact_form_groups'][$groupName]['fields'][$fieldName] = $fieldAttr;
			unset($fields[$fieldName]);
		}

		return $fields;
	}
}
