<?php

App::uses('EvContactFormAppController', 'EvContactForm.Controller');

class ContactFormsController extends EvContactFormAppController {

/**
 * Stub function
 * Used to populate form drop down selects
 *
 * Override in your controller to customise
 */
	protected function _adminPopulateLookups() {
		$config = Configure::read('EvContactForm.forms');

		$keys = array_combine(array_keys($config), array_keys($config));
		$this->set('formData', $keys);

		return;
	}

/**
 * Defines the fields displayed in an admin_form for this model
 *
 * Defaults to all fields in the db table
 *
 * Override in your controller to customise
 */
	protected function _adminFormFields() {
		$Model = $this->{$this->modelClass};

		$fields = parent::_adminFormFields();

		$fields[$Model->alias . ".adwords_tracking"]['type'] = 'text_plain';

		$fields[$Model->alias . ".form_data"]['type'] = 'select';
		$fields[$Model->alias . ".form_data"]['label'] = 'Contact Form Type';

		unset($fields["{$Model->alias}.actioned"]);

		if (!$this->Permissions->hasSuperAdminPermission($this->Auth->user())) {
			unset($fields[$Model->alias . '.system_name']);
		}

		return $fields;
	}

/**
 * Defines the columns displayed in the admin_index results table
 * using a columns whitelist.
 *
 * Override in your controller to customise
 */
	protected function _adminIndexColumns() {
		return array(
			'ContactForm.name' => array(
				'label' => 'Name',
				'type' => 'string'
			),
			'ContactForm.created' => array(
				'label' => 'Submitted',
				'type' => 'datetime_nice'
			),
		);
	}

}
