<?php

// This file would be found at /app/Config/Plugin/ev_contact_form.php
$config = [
	'EvContactForm' => [
		// Set to true to skip the default spam detection. Make sure that other spam protection methods are implemented before like recaptcha.
		'skip_spam_detection' => false,

		'enable_filters' => false, // Enables admin filtering on contact form results. Handy if you have multiple contact forms.
		// Define whether to attach files to notification email
		'attach_files_to_notification_email' => false,
		// Define a maximum combined filesize for attachments above which the files will not be
		// sent with the notification email.
		'notification_email_attachments_max_filesize' => 2.5e+7,
		'forms' => [
			'Enquiry Form' => [
				'template' => false, // Name of your custom view in app/View/Elements
				'use_inline_errors' => false, // toggle to true to show error messages under each invalid form element
				'admin_email_notification' => [ // Set up admin notification emails (exclude to default to Site Settings)
					'from' => [
						'email' => 'admin@evoluted.net',
						'name' => 'Evoluted CMS'
					],
				],
				'user_email_notification' => [ //Set up user notification emails
					/**
					 * The from email/name defaults to being set by the site title and the admin email set in site
					 * setting. Only populate this setting if you wish to hardcode these values to something different
					 * than the site settings.
					 */
					'from' => [
						'email' => 'admin@evoluted.net',
						'name' => 'Evoluted CMS'
					],
					'subject' => 'Enquiry from evoluted CMS',
					'email_field' => 'email', //The contact form field to use as the email address for the user notification.
				],
				'form' => [
					'class' => ''
				],
				'flash' => [ // for more details refer to http://book.cakephp.org/2.0/en/core-libraries/components/sessions.html#SessionComponent::setFlash
					'success' => [
						// The Flash message template
						'element' => 'success',
						'message' => 'Your message has been sent, we will get back to you shortly',
						'params' => [],
						// The array key found under the ‘Flash’ key in the session, defaults as 'flash'
						'key' => 'ev_contact_form'
					],
					'error' => [
						// The Flash message template
						'element' => 'fail',
						'message' => 'There was an issue saving your message, please try again',
						'params' => [],
						// The array key found under the ‘Flash’ key in the session, defaults as 'flash'
						'key' => 'ev_contact_form'
					],
					'validation' => [
						// The Flash message template
						'element' => 'fail',
						'message' => 'Please check you have filled out all the required fields',
						'params' => [],
						// The array key found under the ‘Flash’ key in the session, defaults as 'flash'
						'key' => 'ev_contact_form'
					]
				],
				'name_label' => 'name',

				//Set to true to allow use of sections within fields. Fields with the same section will be put in an
				// array together under a "contact_form_sections" field.
				'use_field_sections' => true,
				//Set to true to allow use of groups within fields. Fields will not be grouped if sections aren't used.
				// Fields with the same group will be put in an array together under a "contact_form_groups" field
				// within a section.
				'use_field_groups' => true,

				'fields' => [
					'name' => [
						'type' => 'text',
						'label' => 'Name',
						'admin-label' => 'Name',
						'class' => 'form-control',
						'div' => 'form-group required',
						'validate' => [
							'required' => [
								'rule' => 'notBlank',
								'message' => 'Please supply your name'
							]
						]
					],
					'email' => [
						'type' => 'email',
						'label' => 'Email',
						'admin-label' => 'Email',
						'class' => 'form-control email',
						'div' => 'form-group required',
						'validate' => [
							'required' => [
								'rule' => 'notBlank',
								'message' => 'Please supply a valid email address'
							],
							'email' => [
								'rule' => 'email',
								'message' => 'Please supply a valid email address'
							]
						]
					],
					'phone' => [
						'admin-label' => 'Phone',
						'type' => 'tel',
						'label' => 'Phone',
						'class' => 'form-control phone',
						'div' => 'form-group',
					],
					'company' => [
						'type' => 'text',
						'label' => 'Company',
						'admin-label' => 'Company',
						'model' => [
							'name' => 'Contact', // The name of the model as you'd pass it to EvClassRegistry.
							'fieldToShow' => '' // This will fall back to the display field if not provided
						],
						'class' => 'form-control',
						'div' => 'form-group required',
						'validate' => [
							'required' => [
								'rule' => 'notBlank',
								'message' => 'Please supply your company name'
							]
						]
					],
					'postcode' => [
						'type' => 'text',
						'label' => 'Postcode',
						'admin-label' => 'Postcode',
						'class' => 'form-control',
						'div' => 'form-group required',
						'validate' => [
							'required' => [
								'rule' => 'notBlank',
								'message' => 'Please supply your postcode'
							]
						]
					],
					'file' => [
						'admin-label' => 'File',
						'type' => 'file',
						'label' => 'Attach File',
						'class' => 'form-control file',
						'div' => 'form-group'
					],
					'subject' => [
						'admin-label' => 'Subject',
						'type' => 'text',
						'label' => 'Subject',
						'class' => 'form-control',
						'div' => 'form-group',
					],
					'message' => [
						'type' => 'textarea',
						'label' => 'Message',
						'admin-label' => 'Message',
						'class' => 'form-control',
						'div' => 'form-group required',
						'validate' => [
							'required' => [
								'rule' => 'notBlank',
								'message' => 'Please supply your message'
							]
						]
					],
					'origin' => [
						'type' => 'hidden',
						'admin-type' => 'string',
						'label' => 'Regarding',
						'admin-label' => 'Origin',
						'class' => 'enquiry-origin',
						'div' => 'input'
					],
					//Section/group examples
					'marketing_agreement' => [
						'type' => 'checkbox',
						'label' => 'GDPR Agreement',
						'admin-label' => 'GDPR agreement',
						'section' => 'marketing',
					],
					'marketing_by_email' => [
						'type' => 'checkbox',
						'label' => 'Marketing By Email',
						'admin-label' => 'Marketing By Email',
						'section' => 'marketing',
						'group' => 'marketing_by',
					],
					'marketing_by_telephone' => [
						'type' => 'checkbox',
						'label' => 'Marketing By Phone',
						'admin-label' => 'Marketing By Phone',
						'section' => 'marketing',
						'group' => 'marketing_by',
					],
					'marketing_by_post' => [
						'type' => 'checkbox',
						'label' => 'Marketing By Post',
						'admin-label' => 'Marketing By Post',
						'section' => 'marketing',
						'group' => 'marketing_by',
					],
				],
				//submit can also be set to `true` to use the auto-generated submit button or `false` for no submit button.
				'submit' => [
					'class' => 'btn btn-default',
					'div' => 'input',
					'type' => 'button',
					'id' => 'enquiry_submit',
					'escape' => false,
					'label' => '&nbsp;',
					'button_text' => 'Send',
				],
				'success_redirect' => [
					'plugin' => false,
					'controller' => 'pages',
					'action' => 'view',
					1
				],
				'error_redirect' => [
					'plugin' => false,
					'controller' => 'pages',
					'action' => 'view',
					1
				],
				//css can also be set to `true` to use the default contact form css. It can also be set to `false` for no css.
				'css' => [
					'EvContactForm.ev-contact-form',
					'EvContactForm.example-csss',
				],
			],
		],
	]
];
