<?php

class AllowNullFieldsAddDefault extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'allow_null_fields_add_default';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'alter_field' => array(
				'contact_forms' => array(
					'email_to' => array('null' => true, 'default' => null),
					'subject_to_staff' => array('null' => true, 'default' => null),
					'is_active' => array('default' => false),
				),
			),
		),
		'down' => array(
			'alter_field' => array(
				'contact_forms' => array(
					'email_to' => array('null' => false, 'default' => ''),
					'subject_to_staff' => array('null' => false, 'default' => ''),
					'is_active' => array('default' => ''),
				),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
