<?php
class AddSubjectToUser extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'add_subject_to_user';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'contact_forms' => array(
					'subject_to_user' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8_general_ci', 'charset' => 'utf8', 'after' => 'body_to_staff'),
				),
			),
			'rename_field' => array(
				'contact_forms' => array(
					'subject' => 'subject_to_staff'
				)
			),
			'alter_field' => array(
				'contact_forms' => array(
					'body_to_staff' => array(
						'after' => 'subject_to_staff'
					)
				)
			)
		),
		'down' => array(
			'drop_field' => array(
				'contact_forms' => array('subject_to_user'),
			),
			'rename_field' => array(
				'contact_forms' => array(
					'subject_to_staff' => 'subject',
				),
			),
			'alter_field' => array(
				'contact_forms' => array(
					'body_to_staff' => array(
						'after' => 'body_to_user'
					)
				)
			)
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
