<div class="ev-contact-form">
	<?php
		echo $this->Session->flash('ev_contact_form');

		if (! isset($form['use_inline_errors']) || $form['use_inline_errors'] !== true):
			echo $this->element('EvContactForm.errors', array('name' => $name));
		endif;

		$form['form']['class'] .= ' disable-button-during-submit';
		$form['form']['type'] = 'file';

		echo $this->Form->create('EvContactForm.' . $name, $form['form']);

		// a custom form submit check field
		echo $this->Form->hidden('contact-form-send', array('value' => $name));

		if (isset($form['fieldset']) && $form['fieldset'] == true):
			echo $this->Html->tag('fieldset', null);

			if (! empty($form['fieldset_message'])):
				if (is_array($form['fieldset_message'])):
					switch ($form['fieldset_message']['source']):
						case 'site_settings':
							echo Configure::read('SiteSetting.EvContactForm.' . $form['fieldset_message']['identifier']);
							break;

						default: // unsupported data source
							error_log('Invalid data source specified for fieldset message');
							break;
					endswitch;
				else:
					echo $this->Html->tag('p', $form['fieldset_message']);
				endif;
			endif;
		endif;

		if (! empty($form['legend'])):
			echo $this->Html->tag('legend', $form['legend']);
		endif;

		foreach ($form['fields'] as $field => $attr):
			echo $this->ShowContactForm->displayField($field, $attr, $form['use_inline_errors']);
		endforeach;

    	// assign the google adwords tracking code when the cookie exists
    	// and we're looping over the correct form element
    	if (! empty($adwordsGclid)):

    		$adwordsGclid = explode('</>', $adwordsGclid);
			$commaSeparatedIds = '';

    		foreach ($adwordsGclid as $gclid) {
				if (empty($commaSeparatedIds)) {
					$commaSeparatedIds = $gclid;
				} else {
					$commaSeparatedIds .= ', ' . $gclid;
				}
    		}

			$attr = array(
				'type' => 'string',
				'label' => 'Google Adwords Tracking',
				'admin-label' => 'Google Adwords Tracking',
				'div' => 'hidden',
				'value' => $commaSeparatedIds
			);
			echo $this->Form->addField('adwords_tracking', $attr);
    	endif;

		// spam field :)
		echo $this->ShowContactForm->displaySpamField();

		if (!empty($form['submit'])):
			echo $this->ShowContactForm->displaySubmit($name, $form['submit']);
		else :
			echo $this->ShowContactForm->displaySubmit($name);
		endif;

		if (isset($form['fieldset']) && $form['fieldset'] == true):
			echo $this->Html->tag('/fieldset');
		endif;

		echo $this->Form->end();
		echo $this->Html->css('EvContactForm.ev-contact-form');

		// silently output for validation errors to Google Analytics
		if (isset($name)):
			$errorName = $name . '_errors';
		endif;

		if (! empty($$errorName)):
			$gaErrorString = '';
			foreach ($$errorName as $gaError):
				$gaErrorString .= "ga('send', 'event', 'Errors', 'Validation Error', '$gaError');";
			endforeach;

			echo $this->Html->scriptBlock($gaErrorString);
		endif;
	?>
</div>
