# EvContactForm

## Installation

- Run `composer require evoluted/contact-form` to pull in the latest version

See ev_contact_form.php for example configuration

- Copy to `App/Config/Plugin/ev_contact_form.php`

```
$config = [
	'enable_filters' => false, // Enables admin filtering on contact form results. Handy if you have multiple contact forms.

	'EvContactForm' => [
		'Enquiry Form' => [
			'template' => false, // Name of your custom view in app/View/Elements
			'use_inline_errors' => false, // toggle to true to show error messages under each invalid form element
			'form' => [
				'class' => ' light'
			],
			'flash' => [ // for more details refer to http://book.cakephp.org/2.0/en/core-libraries/components/sessions.html#SessionComponent::setFlash
				'success' => [
					// The Flash message template
					'element' => 'success',
					'message' => 'Your message has been sent, we will get back to you shortly',
					'params' => [],
					// The array key found under the ‘Flash’ key in the session, defaults as 'flash'
					'key' => 'ev_contact_form'
				],
				'error' => [
					// The Flash message template
					'element' => 'fail',
					'message' => 'There was an issue saving your message, please try again',
					'params' => [],
					// The array key found under the ‘Flash’ key in the session, defaults as 'flash'
					'key' => 'ev_contact_form'
				],
				'validation' => [
					// The Flash message template
					'element' => 'fail',
					'message' => 'Please check you have filled out all the required fields',
					'params' => [],
					// The array key found under the ‘Flash’ key in the session, defaults as 'flash'
					'key' => 'ev_contact_form'
				]
			],
			'name_label' => 'name',
			'fields' => [
				'name' => [
					'type' => 'string',
					'label' => 'Name',
					'admin-label' => 'Name',
					'class' => 'form-control',
					'div' => 'form-group required',
					'validate' => [
						'required' => [
							'rule' => 'notBlank',
							'message' => 'Please supply your name'
						]
					]
				],
				'email' => [
					'type' => 'string',
					'label' => 'Email',
					'admin-label' => 'Email',
					'class' => 'form-control email',
					'div' => 'form-group required',
					'validate' => [
						'required' => [
							'rule' => 'notBlank',
							'message' => 'Please supply a valid email address'
						],
						'email' => [
							'rule' => 'email',
							'message' => 'Please supply a valid email address'
						]
					]
				],
				'phone' => [
					'admin-label' => 'Phone',
					'type' => 'string',
					'label' => 'Phone',
					'class' => 'form-control phone required',
					'div' => 'form-group',
				],
				'company' => [
					'type' => 'string',
					'label' => 'Company',
					'admin-label' => 'Company',
					'class' => 'form-control',
					'div' => 'form-group required',
					'validate' => [
						'required' => [
							'rule' => 'notBlank',
							'message' => 'Please supply your company name'
						]
					]
				],
				'postcode' => [
					'type' => 'string',
					'label' => 'Postcode',
					'admin-label' => 'Postcode',
					'class' => 'form-control',
					'div' => 'form-group required',
					'validate' => [
						'required' => [
							'rule' => 'notBlank',
							'message' => 'Please supply your postcode'
						]
					]
				],
				'subject' => [
					'type' => 'string',
					'label' => 'Subject',
					'class' => 'form-control',
					'div' => 'form-group required',
				],
				'message' => [
					'type' => 'text_plain',
					'label' => '* Message',
					'admin-label' => 'Message',
					'class' => 'form-control',
					'div' => 'form-group required',
					'validate' => [
						'required' => [
							'rule' => 'notBlank',
							'message' => 'Please supply your message'
						]
					]
				],
				'origin' => [
					'type' => 'hidden',
					'admin-type' => 'string',
					'label' => 'Regarding',
					'admin-label' => 'Origin',
					'class' => 'enquiry-origin',
					'div' => 'input'
				],
			],
			'submit' => [
				'admin-label' => 'Subject',
				'class' => 'btn btn-default',
				'div' => 'input',
				'type' => 'button',
				'id' => 'enquiry_submit',
				'escape' => false,
				'label' => '&nbsp;',
				'button_text' => 'Send',
			],
			// Set success_redirect to true to redirect back to the current page
			'success_redirect' => [
				'plugin' => false,
				'controller' => 'pages',
				'action' => 'view',
				1
			]
		]
	]
];
```

### /app/Config/bootstrap

	'EvContactForm'=>array(
		'routes'=>true,
		'bootstrap'=>true
	)

## Setup

To setup the database use the CakeDC Migrations plugin. To run the migrations and setup the database run:-

	Console/cake Migrations.migration run all --plugin EvContactForm

Go to /admin/contact-form/form and create the contact forms, as many as you have defined in config. You will need the ID for the next stage.

## Usage

### Controller

Add to $components.

	'EvContactForm.InjectContactForm'

Add to `$helpers`.

	'EvContactForm.ShowContactForm'

In view action in controller where you want to show & process contact form

	$this->InjectContactForm->display($id, 'enquiry');

Where $id is the ID of the contact form you have created in admin, and 'enquiry' is the name you choose. It posts using this, so make it unique.

### View

Paste the following into the view template where you would like the form to display:

	<?= $this->ShowContactForm->display('enquiry') ?>

To style your contact form, copy `contact_form.ctp` from `EvContactForm/View/Elements` to your Apps `View/Elements` directory.

#### Flash and Validation Errors

There are two options to choose from when showing Flash messages and form validation errors and can be controlled by toggling the `use_inline_errors` flag on each form.

The flag should be left as `false` to display a default Flash message above the form containing an unordered list of validation errors.

Toggling the field to `true` will stop the Flash message and will show form validation messages underneath each failing form element.

### File Uploads
From version 2.2.8.0 you can add a file upload option to your contact form. This simply needs a file field type, and an example of its usage can be found in the `config-fullsample.php` file. Documents are then made viewable in read-only mode when viewing the contact form response in the admin area.

### Sending user emails
If you want to notify the user of the enquiry they have made by email then you need to add an extra setting to the form config.

	'user_email_notification' => true,

By default the subject is the site title and the email is sent from the site title with the admin's email address set up in the CMS site settings. If you would like to customise the subject or who the email is being sent from then you can use the following setting:

	'user_email_notification' => array(
		'from' => array(
			'email' => 'admin@evoluted.net',
			'name' => 'Evoluted CMS'
		),
		'subject' => 'Enquiry from evoluted CMS'
	),

# Conversion success tracking

A field has been added to the site settings (conversion success code) for storing Google tracking code and is echoed on form success:

	echo Configure::read('SiteSetting.tracking.conversion_success_code');

