<?php

// This file would be found at /app/Config/Plugin/ev_contact_form.php
$config = [
	'enable_filters' => false, // Enables admin filtering on contact form results. Handy if you have multiple contact forms.

	'EvContactForm' => [
		'Enquiry Form' => [
			'template' => false, // Name of your custom view in app/View/Elements
			'use_inline_errors' => false, // toggle to true to show error messages under each invalid form element
			'user_email_notification' => array( //Set up user notification emails
				'from' => array(
					'email' => 'admin@evoluted.net',
					'name' => 'Evoluted CMS'
				),
				'subject' => 'Enquiry from evoluted CMS'
			),
			'form' => [
				'class' => ''
			],
			'flash' => [ // for more details refer to http://book.cakephp.org/2.0/en/core-libraries/components/sessions.html#SessionComponent::setFlash
				'success' => [
					// The Flash message template
					'element' => 'success',
					'message' => 'Your message has been sent, we will get back to you shortly',
					'params' => [],
					// The array key found under the ‘Flash’ key in the session, defaults as 'flash'
					'key' => 'ev_contact_form'
				],
				'error' => [
					// The Flash message template
					'element' => 'fail',
					'message' => 'There was an issue saving your message, please try again',
					'params' => [],
					// The array key found under the ‘Flash’ key in the session, defaults as 'flash'
					'key' => 'ev_contact_form'
				],
				'validation' => [
					// The Flash message template
					'element' => 'fail',
					'message' => 'Please check you have filled out all the required fields',
					'params' => [],
					// The array key found under the ‘Flash’ key in the session, defaults as 'flash'
					'key' => 'ev_contact_form'
				]
			],
			'name_label' => 'name',
			'fields' => [
				'name' => [
					'type' => 'text',
					'label' => 'Name',
					'admin-label' => 'Name',
					'class' => 'form-control',
					'div' => 'form-group required',
					'validate' => [
						'required' => [
							'rule' => 'notBlank',
							'message' => 'Please supply your name'
						]
					]
				],
				'email' => [
					'type' => 'email',
					'label' => 'Email',
					'admin-label' => 'Email',
					'class' => 'form-control email',
					'div' => 'form-group required',
					'validate' => [
						'required' => [
							'rule' => 'notBlank',
							'message' => 'Please supply a valid email address'
						],
						'email' => [
							'rule' => 'email',
							'message' => 'Please supply a valid email address'
						]
					]
				],
				'phone' => [
					'admin-label' => 'Phone',
					'type' => 'tel',
					'label' => 'Phone',
					'class' => 'form-control phone',
					'div' => 'form-group',
				],
				'company' => [
					'type' => 'text',
					'label' => 'Company',
					'admin-label' => 'Company',
					'class' => 'form-control',
					'div' => 'form-group required',
					'validate' => [
						'required' => [
							'rule' => 'notBlank',
							'message' => 'Please supply your company name'
						]
					]
				],
				'postcode' => [
					'type' => 'text',
					'label' => 'Postcode',
					'admin-label' => 'Postcode',
					'class' => 'form-control',
					'div' => 'form-group required',
					'validate' => [
						'required' => [
							'rule' => 'notBlank',
							'message' => 'Please supply your postcode'
						]
					]
				],
				'file' => [
					'admin-label' => 'File',
					'type' => 'file',
					'label' => 'Attach File',
					'class' => 'form-control file',
					'div' => 'form-group'
				],
				'subject' => [
					'admin-label' => 'Subject',
					'type' => 'text',
					'label' => 'Subject',
					'class' => 'form-control',
					'div' => 'form-group',
				],
				'message' => [
					'type' => 'textarea',
					'label' => 'Message',
					'admin-label' => 'Message',
					'class' => 'form-control',
					'div' => 'form-group required',
					'validate' => [
						'required' => [
							'rule' => 'notBlank',
							'message' => 'Please supply your message'
						]
					]
				],
				'origin' => [
					'type' => 'hidden',
					'admin-type' => 'string',
					'label' => 'Regarding',
					'admin-label' => 'Origin',
					'class' => 'enquiry-origin',
					'div' => 'input'
				],
			],
			'submit' => [
				'class' => 'btn btn-default',
				'div' => 'input',
				'type' => 'button',
				'id' => 'enquiry_submit',
				'escape' => false,
				'label' => '&nbsp;',
				'button_text' => 'Send',
			],
			'success_redirect' => [
				'plugin' => false,
				'controller' => 'pages',
				'action' => 'view',
				1
			]
		]
	]
];
