<?php
class AddSystemName extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'add_system_name';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'contact_forms' => array(
					'system_name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8_general_ci', 'charset' => 'utf8', 'after' => 'name'),
					'indexes' => array(
						'contact_forms_system_name' => array('column' => array('system_name'), 'unique' => false),
					),
				),
			),
		),
		'down' => array(
			'drop_field' => array(
				'contact_forms' => array('system_name'),
				'indexes' => array(
					'contact_forms_system_name',
				)
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
