<?php
// This file would be found at /app/Config/Plugin/ev_contact_form.php

$config = array(
	'EvContactForm' => array(
		'Enquiry Form' => array(
			'form' => array(
				'class' => ' light'
			),
			'flash' => array( // for more details refer to http://book.cakephp.org/2.0/en/core-libraries/components/sessions.html#SessionComponent::setFlash
				'success' => array(
					'element' => 'flash_success',
					'message' => 'Your message has been sent, we will get back to you shortly',
					'params' => array(),
					'key' => 'ev_contact_form' // leave as 'flash' to display the message in the default location, define new variable if no
				),
				'error' => array(
					'element' => 'flash_fail',
					'message' => 'There was an issue saving your message, please try again',
					'params' => array(),
					'key' => 'ev_contact_form' // leave as 'flash' to display the message in the default location, define new variable if no
				),
				'validation' => array(
					'element' => 'flash_fail',
					'message' => 'Please check you have filled out all the required fields',
					'params' => array(),
					'key' => 'ev_contact_form' // leave as 'flash' to display the message in the default location, define new variable if no
				)
			),
			'name_label' => 'name',
			'fields' => array(
				'name' => array(
					'type' => 'string',
					'label' => '* Name',
					'admin-label' => 'Name',
					'class' => 'form-control required',
					'div' => 'form-group',
					'validate' => array(
						'required' => array(
							'rule' => 'notEmpty',
							'message' => 'Please supply your name'
						)
					)
				),
				'email' => array(
					'type' => 'string',
					'label' => '* Email',
					'admin-label' => 'Email',
					'class' => 'form-control email required',
					'div' => 'form-group',
					'validate' => array(
						'required' => array(
							'rule' => 'notEmpty',
							'message' => 'Please supply a valid email address'
						),
						'email' => array(
							'rule' => 'email',
							'message' => 'Please supply a valid email address'
						)
					)
				),
				'phone' => array(
					'type' => 'string',
					'label' => 'Phone',
					'class' => 'form-control phone required',
					'div' => 'form-group',
				),
				'company' => array(
					'type' => 'string',
					'label' => '* Company',
					'admin-label' => 'Company',
					'class' => 'form-control required',
					'div' => 'form-group',
					'validate' => array(
						'required' => array(
							'rule' => 'notEmpty',
							'message' => 'Please supply your company name'
						)
					)
				),
				'postcode' => array(
					'type' => 'string',
					'label' => '* Postcode',
					'admin-label' => 'Postcode',
					'class' => 'form-control required',
					'div' => 'form-group',
					'validate' => array(
						'required' => array(
							'rule' => 'notEmpty',
							'message' => 'Please supply your postcode'
						)
					)
				),
				'subject' => array(
					'type' => 'string',
					'label' => 'Subject',
					'class' => 'form-control required',
					'div' => 'form-group',
				),
				'message' => array(
					'type' => 'text_plain',
					'label' => '* Message',
					'admin-label' => 'Message',
					'class' => 'form-control required',
					'div' => 'form-group',
					'validate' => array(
						'required' => array(
							'rule' => 'notEmpty',
							'message' => 'Please supply your message'
						)
					)
				),
				'origin' => array(
					'type' => 'hidden',
					'label' => 'Regarding',
					'class' => 'enquiry-origin',
					'div' => 'input'
				),
			),
			'submit' => array(
				'class' => 'btn btn-default',
				'div' => 'input',
				'type' => 'button',
				'id' => 'enquiry_submit',
				'escape' => false,
				'label' => '&nbsp;',
				'button_text' => 'Send',
			),
			'success_redirect' => array(
				'plugin' => false,
				'controller' => 'pages',
				'action' => 'view',
				1
			)
		)
	)
);