<div class="ev-contact-form">
<?php

	echo $this->Element('EvContactForm.errors', array('name' => $name));
	echo $this->Element('EvContactForm.success', array('name' => $name));

	echo $this->Form->create('EvContactForm.' . $name, $form['form']);

	// a custom form submit check field
	echo $this->Form->hidden('contact-form-send', array('value' => $name));

	if (isset($form['fieldset']) && $form['fieldset'] == true) {
		echo '<fieldset>';
		if (isset($form['fieldset_message']) && !empty($form['fieldset_message'])) {
			if (is_array($form['fieldset_message'])) {
				switch ($form['fieldset_message']['source']) {
					case 'site_settings':
						echo Configure::read('SiteSetting.' . $form['fieldset_message']['identifier']);
						break;

					default: // unsupported data source
						error_log('Invalid data source specified for fieldset message');
						break;
				}
			} else {
				echo '<p>' . $form['fieldset_message'] . '</p>';
			}
		}
	}

	if (isset($form['legend']) && $form['legend'] != '') {
		echo '<legend>' . $form['legend'] . '</legend>';
	}

	foreach ($form['fields'] as $field => $attr) {
		if (isset($attr['validate'])) {
			unset($attr['validate']);
		}

		echo $this->Form->addField($field, $attr);
	}

	// spam field :)
	echo $this->Form->addField('email_confirm', array(
		'type' => 'string',
		'div' => array(
			'style' => 'display: none;'
		)
	));


	if (isset($form['submit']['button_text'])) {
		$inputName = $form['submit']['button_text'];
		unset($form['submit']['button_text']);
	} else {
		$inputName = $name . '.save';
	}

	echo $this->Form->input($inputName, $form['submit']);

	if (isset($form['fieldset']) && $form['fieldset'] == true) {
		echo '</fieldset>';
	}

	echo $this->Form->end();

	echo $this->Html->css('EvContactForm.ev-contact-form');
?>
</div>