#EvContactForm

##Installation

See ev_contact_form.php for example configuration

- Copy to App/Config/Plugin/ev_contact_form.php

<pre>$config = array(
	'EvContactForm' => array(
		'Contact Form Name'  => array(
			'name_label' => 'name', // Which name field to show in admin
			'user_email_notification' => array(
				'subject' => 'Thank you for your message',
			),
			'template' => 'contactus_form', // Custom form template, store in your elements folder
			'form' => array( // Normal Cake Form settings
				'class' => 'validate'
			),
			'fieldset' => true,
			'legend' => 'Sample Legend',
			'submit' => array( // Normal button settings
				'class' => 'btn btn-default',
				'div' => 'input',
				'type' => 'button',
				'id' => 'enquiry_submit',
				'escape' => false,
				'label' => false,
				'button_text' => 'Send Enquiry', // Set custom name
			),
			'fields' => array( // Normal cake fields
				'name' => array(
					'type' => 'string',
					'label' => false,
					'admin-label' => 'Name', // Set admin and email label
					'class' => 'form-control required',
					'div' => 'form-group',
					'validate' => array(
						'required' => array(
							'rule' => 'notEmpty',
							'message' => 'Please supply your name'
						)
					)
				),
			),
			'flash' => array( // for more details refer to http://book.cakephp.org/2.0/en/core-libraries/components/sessions.html#SessionComponent::setFlash
				'success' => array(
					'element' => 'flash_success',
					'message' => 'Your message has been sent, we will get back to you shortly',
					'params' => array(),
					'key' => 'flash' // leave as 'flash' to display the message in the default location, define new variable if no
				),
				'error' => array(
					'element' => 'flash_fail',
					'message' => 'There was an issue saving your message, please try again',
					'params' => array(),
					'key' => 'flash' // leave as 'flash' to display the message in the default location, define new variable if no
				),
				'validation' => array(
					'element' => 'flash_fail',
					'message' => 'Please check you have filled out all the required fields',
					'params' => array(),
					'key' => 'flash' // leave as 'flash' to display the message in the default location, define new variable if no
				)
			),
		)
	)
);</pre>


###/app/Config/bootstrap

<pre>'EvContactForm'=>array(
	'routes'=>true,
	'bootstrap'=>true
)</pre>

##Setup

To setup the database use the CakeDC Migrations plugin. To run the migrations and setup the database run:-

<pre>Console/cake Migrations.migration run all --plugin EvContactForm</pre>

Go to /admin/contact-form/form and create the contact forms, as many as you have defined in config. You will need the ID for the next stage.

##Usage

###Controller
Add to $components.

<pre>'EvContactForm.InjectContactForm'</pre>

Add to $helpers.

<pre>'EvContactForm.ShowContactForm'</pre>

In view action in controller where you want to show & process contact form

<pre>$this->InjectContactForm->display($id, 'enquiry');</pre>

Where $id is the ID of the contact form you have created in admin, and 'enquiry' is the name you choose. It posts using this, so make it unique.

####Overriding Models for File Support
In your controller where you call to display, you can pass an optional third parameter to a custom model. This would usually be called EvContactFormContactFormResponse and would allow for documents to be uploaded.

###View

In the view ctp

<pre><?php echo $this->ShowContactForm->display('enquiry'); ?></pre>

##Additional Modifications for File Uploads

Support for file uploads was added in Dec 2014, and currently to use the file upload option you have to pass the custom model name in the display method mentioned above.

You'll also need to manually set your fields, as the CMS's addField handler does not (at the time of writing) support a file field type.

Below is an example of adding one field to your contact form for file support:

<pre>	echo $this->Form->input('FilesDocument.0.model', array('type' => 'hidden', 'value' => 'ContactFormResponse'));
	echo $this->Form->input('FilesDocument.0.attachment_type', array('type' => 'hidden', 'value' => 'FilesDocument'));
	echo $this->Form->input('FilesDocument.0.id', array('type' => 'hidden'));

	echo $this->Form->input('FilesDocument.0.filename',
        array(
            'label' => "",
            'type' => 'file',
            'class' => 'document_upload',
            'div' => array('class' => '')
        )
    );
</pre>