<?php

App::uses('EvContactFormAppModel', 'EvContactForm.Model');

class ContactFormResponse extends EvContactFormAppModel {

	public $belongsTo = array(
		'ContactForm' => array(
			'className' => 'EvContactForm.ContactForm'
		)
	);


	public function readForAdminView($id = null, $params = array()) {

		$data = parent::readForAdminView($id, $params);

		if ($data) {

			// unserialise and manipulate form_data data ready to display
			$formData = unserialize($data[$this->alias]['form_data']);

			if (!empty($formData)) foreach ($formData as $key => $value) {
				$data[$this->alias][$key] = $value;
			}
		}

		return $data;
	}
}
