<?php

App::uses('EvContactFormAppController', 'EvContactForm.Controller');
App::uses('InflectorExt', 'Lib');

class ContactFormResponsesController extends EvContactFormAppController
{

	public $uses = "EvContactForm.ContactFormResponse";

	public $helpers = array(
		'InflectorExt'
	);

	public $adminActions = array(
		'admin_index',
		'admin_actioned',
		'admin_view',
		'admin_delete',
	);


	/**
	 * index action
	 */
	public function _adminIndexActions() {

		return array(
			'Admin View',
			'Delete'
		);
	}

	/**
	 * remove the filter
	 */
	public function _adminFilterFields() {
		return array();
	}

	/**
	 * define the columns to show on the listing
	 */
	public function _adminIndexColumns() {

		return array(
			'ContactFormResponse.name' => array(
				'label' => 'Name',
				'type' => 'string'
			),
			'ContactForm.name' => array(
				'label' => 'Type',
				'type' => 'string'
			),
			'ContactFormResponse.created' => array(
				'label' => 'Submitted',
				'type' => 'datetime_nice'
			),
			'ContactFormResponse.actioned' => array(
				'label' => 'Actioned',
				'type' => 'datetime_nice'
			)
		);
	}

	/**
	 * Pagination settings for admin_index
	 *
	 * Override in your own controller to customise
	 */
	public function _adminIndexPaginate() {

		$conditions = $this->_processFilter();

		$paginate = array(
			//'fields'=>join(",", array_keys($this->_adminIndexColumns())),
			'conditions'=>$conditions,
			'contain' => array('ContactForm'),
			'order' => 'ContactFormResponse.created DESC'
		);

		return $paginate;
	}

	/**
	 * remove the add button
	 */
	public function _adminIndexToolbar() {
		return array();
	}

	/**
	 * Defines the buttons in the toolbar displayed on an admin_form
	 *
	 * Override in your controller to customise
	 */
	public function _adminFormToolbar($id = NULL) {

		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		$toolbar = array();
		if(isset($this->request->data[$modelAlias]['id']) && is_null($this->request->data[$modelAlias]['actioned']))
		{
			$toolbar = array(
				'Mark as Actioned' => array(
					'url' => array(
						'controller' => 'contact_form_responses',
						'plugin' => 'ev_contact_form',
						'action' => 'actioned',
						$this->request->data[$modelAlias]['id']
					),
					'class' => 'toolbar__btn--tick'
				)
			);
		}

		$toolbar['Delete'] = array(
			'url' => array('action' => 'delete', $this->request->data[$modelAlias]['id']),
			'class' => 'toolbar__btn--delete'
		);

		return $toolbar;
	}


	protected function _adminViewFieldsCustom($formType = null) {

		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		$config = Configure::read('EvContactForm');
		if (isset($config[$formType]['fields']) && !empty($config[$formType]['fields'])) {

			$configFields = $config[$formType]['fields'];

			if (isset($configFields) && !empty($configFields)) {

				$fields = array();

				$fields[$modelAlias . '.actioned'] = array(
					'label' => 'Actioned',
					'type' => 'datetime_nice'
				);

				foreach ($configFields as $keyName => $field) {

					$fields[$modelAlias . '.' . $keyName] = array(
						'label' => $field['admin-label'],
						'type' => $field['type'],
					);
				}

				$fields[$modelAlias . '.created'] = array(
					'label' => 'Submitted',
					'type' => 'datetime_nice'
				);
			}
		}

		return (!empty($fields)) ? $fields : array();
	}

	/**
	 * admin view
	 *
	 * actually just a view with an "mark as actioned button"
	 */
	public function admin_view($id = null) {

		parent::admin_view($id);

		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		$formData = $Model->ContactForm->find('first', array(
			'conditions' => array(
				'ContactForm.id' => $this->request->data['ContactFormResponse']['contact_form_id']
			)
		));
		$this->set('fields', $this->_adminViewFieldsCustom($formData['ContactForm']['form_data']));


		return;
	}

	/**
	 * mark the message as actioned
	 *
	 * @param 	int 	contact form id
	 */
	public function admin_actioned($id)
	{

		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		$data = array(
			'ContactFormResponse' => array(
				'actioned' => date('Y-m-d G:i:s')
			)
		);
		$Model->id = $id;

		if ($Model->save($data)) {

			$this->Session->setFlash(array(
				'title' => "Message Updated",
				'description' => 'Message has been marked as actioned'
			), 'flash_success');

			$this->redirect(array(
				'action' => 'index'
			));

		} else {

			$this->Session->setFlash(array(
				'title' => 'Save Failed',
				'description' => 'Failed to mark the message as actioned'
			), 'flash_fail');

			$this->redirect(array(
				'action' => 'edit',
				$id
			));
		}
	}
}