<?php
	echo $this->Html->css(
		'EvCheckout.admin_orders',
		[
			'inline' => false
		]
	);

	echo $this->Html->script(
		[
			'admin_form',
		],
		[
			'inline' => false,
		]
	);
?>

<div class="edit-form">
	<div class="row">
		<div class="col-xs-12 col-sm-6">
			<div class="edit-form__header">
				<h1 class="title"><?php echo $this->InflectorExt->camelToPluralize($displayName); ?> <span>Administration</span></h1>
			</div>
		</div>
		<div class="col-xs-12 col-sm-6">
			<?php echo $this->Element('toolbar'); ?>
		</div>
	</div>

	<?php
		echo $this->element(
			'form_tab',
			[
				'title' => __('Order'),
				'tabContent' => $this->element(
					'EvCheckout.Orders/admin-order-info',
					[]
				),
				'divOptions' => [
					'class' => 'field-order'
				]
			]
		);

		// check to toInject array to see if there are any helpers to run
		if (! empty($toInjectData['helpers'])):
			foreach ($toInjectData['helpers'] as $class => $helper):
				echo $this->{$class}->injectAdminForm();
			endforeach;
		endif;

		if ($additionalTabs = $this->fetch('additionalFormTabs')):
			echo $additionalTabs;
		endif;
	?>
</div>
