<?php
/**
 * Expected parameters:
 * $order - The full order including totals.
 * $currencies - A list of [id => code] pairs usually provided by default by EvCurrency.
 */
?>

<?php if (!empty($completeOrder)): ?>
	<script>
		// Check it's not already been sent first
		var bingCookie = 'order' + <?= h($completeOrder['Order']['id']) ?> + '-bing=success';
		if (document.cookie.indexOf(bingCookie) === -1) {

			function GetRevenueValue() {
				<?php $orderTotals = Hash::combine($order, 'OrderTotal.{n}.name', 'OrderTotal.{n}.amount');?>
				return <?= $orderTotals[Configure::read('EvBasket.labels.grandtotal')]; ?>;
			}

			window.uetq = window.uetq || [];
			window.uetq.push({ 'gv': GetRevenueValue(), 'gc': '<?= $currencies[$order['Order']['currency_id']] ?>'});

			// Save a week-long cookie to record that this tracking
			// has already been sent
			var expires = new Date();
			expires.setDate(expires.getDate() + 7);
			document.cookie = bingCookie + '; expires=' + expires.toUTCString() + ';';
		}

	</script>
<?php endif ?>
