<h2>Confirm &amp; Pay</h2>

<div class="row">

	<?=$this->Flash->render()?>

	<table class="table table-bordered table-striped">
		<thead>
			<tr>
				<th>Item</th>
				<th>Price</th>
				<th>Quantity</th>
				<th>Total</th>
			</tr>
		</thead>

		<tbody>
			<?php if (! empty($basket['BasketItem'])): ?>
				<?php foreach ($basket['BasketItem'] as $key => $BasketItem): ?>
					<tr>
						<td>
							<?=$this->Basket->getItemName($BasketItem)?>
						</td>
						<td>
							<?=$this->Number->currency($BasketItem['unit_price'])?>
						</td>
						<td>
							<?=$this->Basket->quantityField($BasketItem)?>
						</td>
						<td>
							<?=$this->Number->currency($BasketItem['row_total'])?>
						</td>
					</tr>
				<?php endforeach; ?>
			<?php else: ?>
				<tr>
					<td colspan="5">
						There are no items in your basket
					</td>
				</tr>
			<?php endif; ?>
		</tbody>

		<tfoot>
			<?php if (! empty($basket['BasketTotal'])): ?>
				<?php foreach ($basket['BasketTotal'] as $key => $BasketTotal): ?>
					<tr>
						<td colspan="3" class="text-right">
							<span style="padding-right: 25px;">
								<?=$BasketTotal['name']?>
							</span>
						</td>
						<td>
							<?=$this->Number->currency($BasketTotal['amount'])?>
						</td>
					</tr>
				<?php endforeach; ?>
			<?php endif; ?>
		</tfoot>
	</table>

	<div class="col-md-6">
		<h3>Delivery Address</h3>

		<?=$this->AddressBook->display($selectedAddresses['delivery'])?>
	</div>

</div>

<div class="row">
	<div class="col-xs-12">
		<?php
			echo $this->Form->create(false);

			echo $this->Form->submit('Proceed');

			echo $this->Form->end();
		?>
	</div>
</div>
