<?php
App::uses('EvCheckoutAppModel', 'EvCheckout.Model');
/**
 * OrderItemData Model
 *
 * @property OrderItem $OrderItem
 */
class OrderItemData extends EvCheckoutAppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'name';

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'order_item_id' => array(
			'numeric' => array(
				'rule' => array('numeric'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
		'name' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
	);

	//The Associations below have been created with all possible keys, those that are not needed can be removed

/**
 * belongsTo associations
 *
 * @var array
 */
	public $belongsTo = array(
		'OrderItem' => array(
			'className' => 'EvCheckout.OrderItem'
		)
	);

/**
 * Set a data row for the order item (updates or creates one based on the order item id and name).
 *
 * @param int    $orderItemId Id of the basket that the record belongs to.
 * @param string $name        Name of the data row.
 * @param string $data        Value of the data row.
 * @return bool True is saved successfully, false otherwise.
 */
	public function setItemData($orderItemId, $name, $data) {
		$record = $this->checkForExistingData($orderItemId, $name);

		if ($record !== false) {
			$this->set('id', $record);
		} else {
			$this->clear();
		}

		$this->set([
			'order_item_id' => $orderItemId,
			'name' => $name,
			'item_data' => $data
		]);

		return $this->save();
	}

/**
 * Check if there is any existing item data for the order item with the provided name. If there is
 * then return the id of the order item data, otherwise return false.
 *
 * @param int    $orderItemId  The id of the order item to check for data on.
 * @param string $itemDataName The name of the order item data to check for.
 * @return int|bool The id of the order item data if found, false otherwise.
 */
	public function checkForExistingData($orderItemId, $itemDataName) {
		$existingData = $this->find(
			'first',
			[
				'conditions' => [
					$this->alias . '.order_item_id' => $orderItemId,
					$this->alias . '.name' => $itemDataName,
				]
			]
		);

		if (!empty($existingData[$this->alias]['id'])) {
			return $existingData[$this->alias]['id'];
		}

		return false;
	}
}
