<?php
App::uses('EvCheckoutAppModel', 'EvCheckout.Model');
/**
 * OrderItem Model
 *
 * @property Order $Order
 * @property OrderItemData $OrderItemData
 */
class OrderItem extends EvCheckoutAppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'name';

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'name' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
		'order_id' => array(
			'numeric' => array(
				'rule' => array('numeric'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
		'order_item_status_id' => array(
			'numeric' => array(
				'rule' => array('numeric'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
	);

	//The Associations below have been created with all possible keys, those that are not needed can be removed

/**
 * belongsTo associations
 *
 * @var array
 */
	public $belongsTo = array(
		'Order' => array(
			'className' => 'EvCheckout.Order'
		),
		'OrderItemStatus' => array(
			'className' => 'EvCheckout.OrderItemStatus'
		)
	);

/**
 * hasMany associations
 *
 * @var array
 */
	public $hasMany = array(
		'OrderItemData' => array(
			'className' => 'EvCheckout.OrderItemData'
		),
		'OrderItemUpdate' => array(
			'className' => 'EvCheckout.OrderItemUpdate'
		),
	);

/**
 * constructor - setup the dynamic relationships
 *
 */
	public function __construct($id = false, $table = null, $ds = null) {
		parent::__construct($id, $table, $ds);

		$relationships = Configure::read('EvCheckout.OrderItemBelongsTo');
		if (! empty($relationships)) {
			$belongsTo = array();
			foreach ($relationships as $key => $value) {
				$belongsTo[$key] = $value;
			}

			if (! empty($belongsTo)) {
				$this->bindModel(
					array(
						'belongsTo' => $belongsTo
					),
					false
				);
			}
		}
	}

/**
 * Executed before a save() operation.
 *
 * @param $Model
 * @param array $options
 * @return  boolean
 */
	public function beforeSave($options = array()) {
		// If we're editing an existing object, save off a copy of
		// the object as it exists before any changes.
		if (!empty( $this->id )) {
			$this->_original = $this->find('first', array(
				'conditions' => array(
					'id' => $this->id
				)
			));
		}
		return parent::beforeSave($options);
	}

/**
 * afterSave Callback
 *
 * @param bool $created Whether or not the save created a record.
 * @param array $options Options passed from Model::save().
 * @return void
 */
	public function afterSave($created, $options = array()) {
		// We are looking for changes so don't do anything if created
		if (! $created) {
			// Get the updated version of the model
			$data = $this->find('first', array(
				'conditions' => array(
					'id' => $this->id
				)
			));

			// Compare the order_item_status_id with the before save version
			if ($data['OrderItem']['order_item_status_id'] != $this->_original['OrderItem']['order_item_status_id']) {
				// The order status has been updated so log the change
				$this->OrderItemUpdate->create();

				$orderItemUpdate = array(
					'OrderItemUpdate' => array(
						'order_item_id' => $this->id,
						'field' => 'order_item_status_id',
						'previous_value' => $this->_original['OrderItem']['order_item_status_id'],
						'new_value' => $data['OrderItem']['order_item_status_id']
					)
				);

				$this->OrderItemUpdate->save($orderItemUpdate);
			}
		}

		return parent::afterSave($created, $options);
	}

/**
 * Update the order item with an amended order item status.
 *
 * @param int $orderItemId 	The order item ID to update.
 * @param int $orderItemStatusId The order item status ID to set.
 * @return 	bool
 */
	public function updateStatus($orderItemId, $orderItemStatusId) {
		return $this->save(
			[
				'OrderItem' => [
					'id' => $orderItemId,
					'order_item_status_id' => $orderItemStatusId,
				],
			]
		);
	}
}
