<?php
App::uses('EvCheckoutAppModel', 'EvCheckout.Model');
/**
 * OrderData Model
 *
 * @property Order $Order
 */
class OrderData extends EvCheckoutAppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'name';

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'order_id' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
		'name' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
	);

	// The Associations below have been created with all possible keys, those that are not needed can be removed

/**
 * belongsTo associations
 *
 * @var array
 */
	public $belongsTo = array(
		'Order' => array(
			'className' => 'Order',
			'foreignKey' => 'order_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)
	);

/**
 * Set a data row for the order (updates or creates one based on the order id and name)
 *
 * @param int    $orderId   Id of the order that the record belongs to.
 * @param string $dataName  Name of the data row.
 * @param string $data      Value of the data row.
 * @param bool   $isVisible True if the data should be visible or not.
 * @return bool True if the data was set, false otherwise.
 */
	public function setData($orderId, $dataName, $data, $isVisible = false) {
		$record = $this->checkForExistingData($orderId, $dataName);

		if ($record !== false) {
			$this->set('id', $record);
		} else {
			$this->clear();
		}

		$this->set(
			[
				'order_id' => $orderId,
				'name' => $dataName,
				'data' => json_encode($data),
				'is_visible' => $isVisible
			]
		);

		return (bool)$this->save();
	}

/**
 * Check if there is any existing data for the order with the provided name. If there is
 * then return the id of the order data, otherwise return false.
 *
 * @param int    $orderId  The id of the order to check for data on.
 * @param string $dataName The name of the basket data to check for.
 * @return int|bool The id of the order data if found, false otherwise.
 */
	public function checkForExistingData($orderId, $dataName) {
		$existingData = $this->find(
			'first',
			[
				'conditions' => [
					$this->alias . '.order_id' => $orderId,
					$this->alias . '.name' => $dataName,
				]
			]
		);

		if (!empty($existingData[$this->alias]['id'])) {
			return $existingData[$this->alias]['id'];
		}

		return false;
	}
}
