<?php

App::uses('ArrayUtil', 'EvCore.Lib');

class OrderLib {

/**
 * Given the order array and the name of the total to get, return the total.
 *
 * @param array  $order     The order to search in.
 * @param string $totalName The name of the total to find.
 * @return mixed The total if found, false if not found and null if no order totals were provided.
 */
	public function findOrderTotal($order, $totalName) {
		if (empty($order['OrderTotal']) || empty($totalName)) {
			return null;
		}

		return ArrayUtil::findFirst($order['OrderTotal'], 'name', $totalName);
	}

/**
 * Given the order array and the name of the data to get, return the data.
 *
 * @param array  $order    The order item to search in.
 * @param string $dataName The path to search data for
 * @return mixed|bool|null The data if found, false if not found and null if no order data was provided.
 */
	public function findOrderData($order, $dataName) {
		if (empty($order['OrderData']) || empty($dataName)) {
			return null;
		}

		return ArrayUtil::findFirst($order['OrderData'], 'name', $dataName, 'data');
	}

/**
 * Given the array of item data and the name of the data to get, return the data.
 *
 * @param array  $orderItem    The order item to search in.
 * @param string $itemDataName The path to search data for
 * @return mixed|bool|null The data if found, false if not found and null if no order data was provided.
 */
	public function findOrderItemData($orderItem, $itemDataName) {
		if (empty($orderItem['OrderItemData']) || empty($itemDataName)) {
			return null;
		}

		return ArrayUtil::findFirst($orderItem['OrderItemData'], 'name', $itemDataName, 'item_data');
	}

/**
 * Checks that the transaction given is accessible in the current session
 *
 * @param int $transactionId The transaction ID to check
 * @param int $userId The user ID to check
 * @return bool True if accessible, false if not.
 */
	public static function checkTransactionAccess($transactionId, $userId) {
		$Transaction = EvClassRegistry::init('EvTransactions.Transaction');
		$transaction = $Transaction->find('first', [
			'conditions' => [
				'Transaction.id' => $transactionId,
			],
			'contain' => [
				'Order'
			]
		]);

		// Check for invalid transaction ID
		if (empty($transaction)) {
			return false;
		}

		// Check for an order ID in the current session
		$orderIdFromSession = CakeSession::read('EvCheckout.last_order_id', 0);
		if (!empty($orderIdFromSession) && !empty($transaction['Order']['id']) && $orderIdFromSession == $transaction['Order']['id']) {
			// The order was placed from this session
			return true;
		}

		// Check if the current logged in user matches the order user
		if (!empty($transaction['Order']['user_id']) && !empty($userId) && $userId == $transaction['Order']['user_id']) {
			// The order was placed by the current logged in user
			return true;
		}

		return false;
	}
}
