<?php

App::uses('AuditLogPresenter', 'EvAuditLog.Lib');

class OrderTotalAuditLogPresenter extends AuditLogPresenter {

/**
 * If the property should appear in the log
 *
 * @param array $audit The audit data
 * @param array $auditDelta The delta data
 * @return bool True if it should appear, false if not
 */
	public function shouldPresentProperty($audit, $auditDelta) {
		switch ($auditDelta['property_name']) {
			case 'id':
			case 'name':
			case 'order_id':
			case 'sequence':
			case 'display_inc_tax':
			case 'display_ex_tax':
				return false;
			default:
				return parent::shouldPresentProperty($audit, $auditDelta);
		}
	}

/**
 * The property name is the name of the database field that changed. This method turns the field name
 * into something readable.
 *
 * @param array $audit      The audit data.
 * @param array $auditDelta The aduit delta array.
 * @return string Humanised property name.
 */
	public function presentPropertyName($audit, $auditDelta) {
		switch ($auditDelta['property_name']) {
			case 'amount':
				return InflectorExt::Humanize($this->_lookupValue('EvCheckout.OrderTotal', $audit['entity_id']));
			default:
				return parent::presentPropertyName($audit, $auditDelta);
		}
	}

/**
 * presentItemName
 *
 * @param array $audit The audit data
 * @return string The item name
 */
	public function presentItemName($audit) {
		return 'Order Total';
	}
}
