<?php

App::uses('AuditLogPresenter', 'EvAuditLog.Lib');

class OrderItemDataAuditLogPresenter extends AuditLogPresenter {

/**
 * If the property should appear in the log
 *
 * @param array $audit The audit data
 * @param array $auditDelta The delta data
 * @return bool True if it should appear, false if not
 */
	public function shouldPresentProperty($audit, $auditDelta) {
		switch ($auditDelta['property_name']) {
			case 'item_data':
				return true;
			default:
				return false;
		}
	}

/**
 * The property name is the name of the database field that changed. This method turns the field name
 * into something readable.
 *
 * @param array $audit      The audit data.
 * @param array $auditDelta The aduit delta array.
 * @return string Humanised property name.
 */
	public function presentPropertyName($audit, $auditDelta) {
		switch ($auditDelta['property_name']) {
			case 'item_data':
				return InflectorExt::Humanize($this->_lookupValue('EvCheckout.OrderItemData', $audit['entity_id']));
			default:
				return parent::presentPropertyName($audit, $auditDelta);
		}
	}

/**
 * presentItemName
 *
 * @param array $audit The audit data
 * @return string The item name
 */
	public function presentItemName($audit) {
		$orderItemData = json_decode($audit['json_object'], true);
		return 'Item Data: ' . $this->_lookupValue('EvCheckout.OrderItem', $orderItemData['OrderItemData']['order_item_id']) . ' - ' . InflectorExt::Humanize($this->_lookupValue('EvCheckout.OrderItemData', $audit['entity_id']));
	}
}
