<?php

App::uses('AuditLogPresenter', 'EvAuditLog.Lib');

class OrderItemAuditLogPresenter extends AuditLogPresenter {

/**
 * The property name is the name of the database field that changed. This method turns the field name
 * into something readable.
 *
 * @param array $audit      The audit data.
 * @param array $auditDelta The aduit delta array.
 * @return string Humanised property name.
 */
	public function presentPropertyName($audit, $auditDelta) {
		switch ($auditDelta['property_name']) {
			case 'order_item_status_id':
				return 'Order Item Status';
			default:
				return InflectorExt::humanize($auditDelta['property_name']);
		}
	}

/**
 * Present a audit delta value. If the value is null return an empty string. If the model is present
 * on the audit then an attempt to use a plugin presenter will occur, otherwise the value is returned
 * withou any modification.
 *
 * @param array $audit      The audit data.
 * @param array $auditDelta The aduit delta array.
 * @param string $value 	The default value
 * @return string The value to present.
 */
	public function presentValue($audit, $auditDelta, $value) {
		switch ($auditDelta['property_name']) {
			case 'order_item_status_id':
				$value = $this->_lookupValue('EvCheckout.OrderItemStatus', $value);
				break;
		}

		return parent::presentValue($audit, $auditDelta, $value);
	}
/**
 * If the property should appear in the log
 *
 * @param array $audit The audit data
 * @param array $auditDelta The delta data
 * @return bool True if it should appear, false if not
 */
	public function shouldPresentProperty($audit, $auditDelta) {
		switch ($auditDelta['property_name']) {
			case 'id':
			case 'name':
			case 'order_id':
			case 'sequence':
			case 'model':
			case 'model_id':
			case 'unit_price_inc_tax':
			case 'row_total_inc_tax':
				return false;
			default:
				return parent::shouldPresentProperty($audit, $auditDelta);
		}
	}

/**
 * presentItemName
 *
 * @param array $audit The audit data
 * @return string The item name
 */
	public function presentItemName($audit) {
		return 'Item: ' . $this->_lookupValue('EvCheckout.OrderItem', $audit['entity_id']);
	}
}
