<?php

App::uses('AuditLogPresenter', 'EvAuditLog.Lib');

class OrderDataAuditLogPresenter extends AuditLogPresenter {

/**
 * If the property should appear in the log
 *
 * @param array $audit The audit data
 * @param array $auditDelta The delta data
 * @return bool True if it should appear, false if not
 */
	public function shouldPresentProperty($audit, $auditDelta) {
		switch ($auditDelta['property_name']) {
			case 'data':
				return true;
			default:
				return false;
		}
	}

/**
 * The property name is the name of the database field that changed. This method turns the field name
 * into something readable.
 *
 * @param array $audit      The audit data.
 * @param array $auditDelta The aduit delta array.
 * @return string Humanised property name.
 */
	public function presentPropertyName($audit, $auditDelta) {
		switch ($auditDelta['property_name']) {
			case 'data':
				return InflectorExt::Humanize($this->_lookupValue('EvCheckout.OrderData', $audit['entity_id']));
			default:
				return parent::presentPropertyName($audit, $auditDelta);
		}
	}

/**
 * presentItemName
 *
 * @param array $audit The audit data
 * @return string The item name
 */
	public function presentItemName($audit) {
		return 'Order Data';
	}
}
