<?php

App::uses('EvCheckoutAppController', 'EvCheckout.Controller');

class OrderNotesController extends EvCheckoutAppController {

	public $name = 'OrderNotes';

/**
 * Called before the controller action.
 *
 * @return void
 * @link http://book.cakephp.org/2.0/en/controllers.html#request-life-cycle-callbacks
 */
	public function beforeFilter() {
		$this->adminActions[] = 'admin_add';

		parent::beforeFilter();
	}

/**
 * Add an order note. Assign a user id from the current session. If a user isn't available then
 * the user id will be set to null to distinguish it as being added by the system.
 *
 * @param int $orderId The id of the order to associated the note with.
 * @return redirect.
 */
	public function admin_add($orderId) {
		$Model = $this->{$this->modelClass};

		if (!empty($this->request->data[$Model->alias]['note'])) {
			$newOrderNote = [
				'note' => $this->request->data[$Model->alias]['note']
			];

			if (!isset($this->request->data[$Model->alias]['is_admin_note'])) {
				$this->request->data[$Model->alias]['is_admin_note'] = true;
			}

			$newOrderNote['is_admin_note'] = $this->request->data[$Model->alias]['is_admin_note'];
			$newOrderNote['order_id'] = $orderId;

			if (!empty($this->Auth->user('User.id'))) {
				$newOrderNote['user_id'] = $this->Auth->user('User.id');
			}

			if ($Model->save($newOrderNote)) {
				$this->Flash->success([
					'title' => InflectorExt::camelToHumanize($Model->displayName) . " added",
					'description' => "The " . InflectorExt::camelToHumanize($Model->displayName) . " has been successfully added!"
				]);
			} else {
				$this->Flash->fail([
					'title' => 'Save failed',
					'description' => 'Failed to save ' . InflectorExt::camelToHumanize($Model->displayName) . ', see below for details',
					'list' => $Model->validationErrors
				]);
			}
		}

		return $this->redirect(
			[
				'plugin' => 'ev_checkout',
				'admin' => true,
				'controller' => 'orders',
				'action' => 'edit',
				$orderId
			]
		);
	}
}
