<?php

App::uses('AppComponent', 'Controller/Component');

class OrderPagesComponent extends AppComponent {

/**
 * Get the id of the order success page.
 *
 * @param int $orderId The id of successful order.
 * @return int The id of the order success page.
 */
	public function getOrderSuccessPageId($orderId) {
		return Configure::read('EvCheckout.pageIds.success');
	}

/**
 * Get the id of the order failed page.
 *
 * @return int The id of the order success page.
 */
	public function getOrderFailPageId() {
		return Configure::read('EvCheckout.pageIds.fail');
	}

/**
 * Set the view for the order success page. Set any custom data to the view with this method or assign a different view
 * by extending it.
 *
 * @param int $orderId The id of successful order.
 * @param int $pageId  The id of the order success page.
 * @return void.
 */
	public function setOrderSuccessPage($orderId, $pageId) {
		$this->_controller->view = 'EvCheckout./Fallbacks/Order/success';
	}

/**
 * Get the id of the order fail page.
 *
 * @return int The id of the order fail page.
 */
	public function getOrderFailPage() {
		return Configure::read('EvCheckout.pageIds.fail');
	}

/**
 * Set the view for the order fail page. Set any custom data to the view with this method or assign a different view
 * by extending it.
 *
 * @param int $pageId The id of the order fail page.
 * @return void.
 */
	public function setOrderFailPage($pageId) {
		$this->_controller->view = 'EvCheckout./Fallbacks/Order/fail';
	}

/**
 * Show a basic page to the user saying their order was successful but don't show any private information.
 * This is a very edge case scenario.
 *
 * @param int $transactionId The transaction ID
 * @return void
 */
	public function showUnauthorisedSuccess($transactionId) {
		$this->_controller->loadModel('EvTransactions.Transaction');
		$this->_controller->set('orderNumber', $this->_controller->Transaction->field('Transaction.model_id', [
			'Transaction.id' => $this->_controller->request->query['transaction'],
			'Transaction.model' => 'EvCheckout.Order',
		]));
		$this->_controller->view = 'EvCheckout.Orders/unauthorised-success';
	}

/**
 * Show a basic page to the user saying their order has failed but don't show any private information.
 * This is a very edge case scenario.
 *
 * @param int $transactionId The transaction ID
 * @return void
 */
	public function showUnauthorisedFail($transactionId) {
		$this->_controller->view = 'EvCheckout.Orders/unauthorised-fail';
	}
}
