<?php

$path = dirname(__FILE__);
$pluginDir = explode(DS, dirname($path . '../'));

$pluginName = array_pop($pluginDir);
$pluginConfig = Inflector::underscore($pluginName);
Configure::load($pluginName . '.config');

// Load overrides to settings if they exist
$configOverridePath = APP . 'Config' . DS;
$configOverride = 'Plugin' . DS . $pluginConfig . '.php';

if (file_exists($configOverridePath . $configOverride) && is_readable($configOverridePath . $configOverride)) {

	Configure::load($configOverride);
}

// register orderBuilders as app paths so we can get objects
App::build(
	array(
		'OrderBuilders' => array(
			'%s' . 'Lib' . DS . 'OrderBuilder' . DS
		)
	),
	App::REGISTER
);

// require the events - setup paid listener for sending emails
require_once (ROOT . DS . 'Plugin' . DS . 'EvCheckout' . DS . 'Config' . DS . 'events.php');