<?php

App::uses('MigrationUtil', 'EvMigrationUtil.Lib');

class AddIndexesToOrderTables extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'add_indexes_to_order_tables';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = [
		'up' => [
			'create_field' => [
				'ev_checkout_order_data' => [
					'indexes' => [
						'order_data_order_id' => ['column' => 'order_id', 'unique' => false],
						'order_data_name' => ['column' => 'name', 'unique' => false],
					],
				],
				'ev_checkout_order_statuses' => [
					'indexes' => [
						'order_statuses_name' => ['column' => 'name', 'unique' => false],
					],

				],
			],
		],
		'down' => [
			'drop_field' => [
				'ev_checkout_order_data' => [
					'indexes' => [
						'order_data_order_id',
						'order_data_name',
					],
				],
				'ev_checkout_order_statuses' => [
					'indexes' => [
						'order_statuses_name',
					],
				],
			],
		],
	];

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
